/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.sonar.api.BatchComponent;

public class PathResolver
implements BatchComponent {
    public File relativeFile(File dir, String path) {
        Preconditions.checkArgument((boolean)dir.isDirectory(), (Object)("Not a directory: " + dir.getAbsolutePath()));
        File file = new File(path);
        if (!file.isAbsolute()) {
            try {
                file = new File(dir, path).getCanonicalFile();
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to resolve path '" + path + "' relative to: " + dir.getAbsolutePath(), e);
            }
        }
        return file;
    }

    public List<File> relativeFiles(File dir, List<String> paths) {
        ArrayList result = Lists.newArrayList();
        for (String path : paths) {
            result.add(this.relativeFile(dir, path));
        }
        return result;
    }

    public RelativePath relativePath(Collection<File> dirs, File file) {
        ArrayList stack = Lists.newArrayList();
        String path = FilenameUtils.normalize((String)file.getAbsolutePath());
        for (File cursor = new File(path); cursor != null; cursor = cursor.getParentFile()) {
            File parentDir = this.parentDir(dirs, cursor);
            if (parentDir != null) {
                return new RelativePath(parentDir, Joiner.on((String)"/").join((Iterable)stack));
            }
            stack.add(0, cursor.getName());
        }
        return null;
    }

    public String relativePath(File dir, File file) {
        ArrayList stack = Lists.newArrayList();
        String path = FilenameUtils.normalize((String)file.getAbsolutePath());
        for (File cursor = new File(path); cursor != null; cursor = cursor.getParentFile()) {
            if (this.containsFile(dir, cursor)) {
                return Joiner.on((String)"/").join((Iterable)stack);
            }
            stack.add(0, cursor.getName());
        }
        return null;
    }

    private File parentDir(Collection<File> dirs, File cursor) {
        for (File dir : dirs) {
            if (!FilenameUtils.equalsNormalizedOnSystem((String)dir.getAbsolutePath(), (String)cursor.getAbsolutePath())) continue;
            return dir;
        }
        return null;
    }

    private boolean containsFile(File dir, File cursor) {
        return FilenameUtils.equalsNormalizedOnSystem((String)dir.getAbsolutePath(), (String)cursor.getAbsolutePath());
    }

    public static final class RelativePath {
        private File dir;
        private String path;

        public RelativePath(File dir, String path) {
            this.dir = dir;
            this.path = path;
        }

        public File dir() {
            return this.dir;
        }

        public String path() {
            return this.path;
        }
    }
}

