/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.maven;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonar.api.batch.maven.MavenUtils;

@Deprecated
public class MavenPlugin {
    private static final String CONFIGURATION_ELEMENT = "configuration";
    private Plugin plugin;
    private Xpp3Dom configuration;

    public MavenPlugin(Plugin plugin) {
        this.plugin = plugin;
        this.configuration = (Xpp3Dom)plugin.getConfiguration();
        if (this.configuration == null) {
            this.configuration = new Xpp3Dom(CONFIGURATION_ELEMENT);
            plugin.setConfiguration((Object)this.configuration);
        }
    }

    public MavenPlugin(String groupId, String artifactId, String version) {
        this.plugin = new Plugin();
        this.plugin.setGroupId(groupId);
        this.plugin.setArtifactId(artifactId);
        this.plugin.setVersion(version);
        this.configuration = new Xpp3Dom(CONFIGURATION_ELEMENT);
        this.plugin.setConfiguration((Object)this.configuration);
    }

    public Xpp3Dom getConfigurationXmlNode() {
        return this.configuration;
    }

    public MavenPlugin setVersion(String version) {
        this.plugin.setVersion(version);
        return this;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getParameter(String key) {
        Xpp3Dom node = this.findNodeWith(key);
        return node == null ? null : node.getValue();
    }

    public String[] getParameters(String key) {
        String[] keyParts = StringUtils.split((String)key, (String)"/");
        Xpp3Dom node = this.configuration;
        for (int i = 0; i < keyParts.length - 1; ++i) {
            node = MavenPlugin.getOrCreateChild(node, keyParts[i]);
        }
        Xpp3Dom[] children = node.getChildren(keyParts[keyParts.length - 1]);
        String[] result = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            result[i] = children[i].getValue();
        }
        return result;
    }

    public MavenPlugin setParameter(String key, String value) {
        MavenPlugin.checkKeyArgument(key);
        String[] keyParts = StringUtils.split((String)key, (String)"/");
        Xpp3Dom node = this.configuration;
        for (String keyPart : keyParts) {
            node = MavenPlugin.getOrCreateChild(node, keyPart);
        }
        node.setValue(value);
        return this;
    }

    public void setParameter(String key, String value, boolean override) {
        if (this.getParameter(key) == null || override) {
            this.setParameter(key, value);
        }
    }

    public void removeParameters() {
        this.configuration = new Xpp3Dom(CONFIGURATION_ELEMENT);
        this.plugin.setConfiguration((Object)this.configuration);
    }

    public MavenPlugin addParameter(String key, String value) {
        String[] keyParts = StringUtils.split((String)key, (String)"/");
        Xpp3Dom node = this.configuration;
        for (int i = 0; i < keyParts.length - 1; ++i) {
            node = MavenPlugin.getOrCreateChild(node, keyParts[i]);
        }
        Xpp3Dom leaf = new Xpp3Dom(keyParts[keyParts.length - 1]);
        leaf.setValue(value);
        node.addChild(leaf);
        return this;
    }

    private static Xpp3Dom getOrCreateChild(Xpp3Dom node, String key) {
        int childIndex = MavenPlugin.getIndex(key);
        if (node.getChildren(MavenPlugin.removeIndexSnippet(key)).length <= childIndex) {
            Xpp3Dom child = new Xpp3Dom(MavenPlugin.removeIndexSnippet(key));
            node.addChild(child);
            return child;
        }
        return node.getChildren(MavenPlugin.removeIndexSnippet(key))[childIndex];
    }

    private static int getIndex(String key) {
        if (key.matches(".*?\\[\\d+\\]")) {
            return Integer.parseInt(StringUtils.substringBetween((String)key, (String)"[", (String)"]"));
        }
        return 0;
    }

    private static String removeIndexSnippet(String key) {
        return StringUtils.substringBefore((String)key, (String)"[");
    }

    public void removeParameter(String key) {
        Xpp3Dom node = this.findNodeWith(key);
        if (node != null) {
            MavenPlugin.remove(node);
        }
    }

    private Xpp3Dom findNodeWith(String key) {
        MavenPlugin.checkKeyArgument(key);
        String[] keyParts = key.split("/");
        Xpp3Dom node = this.configuration;
        for (String keyPart : keyParts) {
            if (node.getChildren(MavenPlugin.removeIndexSnippet(keyPart)).length <= MavenPlugin.getIndex(keyPart)) {
                return null;
            }
            if ((node = node.getChildren(MavenPlugin.removeIndexSnippet(keyPart))[MavenPlugin.getIndex(keyPart)]) != null) continue;
            return null;
        }
        return node;
    }

    private static void remove(Xpp3Dom node) {
        Xpp3Dom parent = node.getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Xpp3Dom child = parent.getChild(i);
            if (!child.equals((Object)node)) continue;
            parent.removeChild(i);
            break;
        }
    }

    public boolean hasConfiguration() {
        return this.configuration.getChildCount() > 0;
    }

    private static void checkKeyArgument(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter 'key' should not be null.");
        }
    }

    public static MavenPlugin registerPlugin(MavenProject pom, String groupId, String artifactId, String version, boolean overrideVersion) {
        MavenPlugin plugin = MavenPlugin.getPlugin(pom, groupId, artifactId);
        if (plugin == null) {
            plugin = new MavenPlugin(groupId, artifactId, version);
        } else if (overrideVersion) {
            plugin.setVersion(version);
        }
        MavenPlugin.unregisterPlugin(pom, groupId, artifactId);
        pom.getBuild().addPlugin(plugin.getPlugin());
        return plugin;
    }

    public static MavenPlugin getPlugin(MavenProject pom, String groupId, String artifactId) {
        if (pom == null) {
            return null;
        }
        Plugin plugin = null;
        if (pom.getBuildPlugins() != null) {
            plugin = MavenPlugin.getPlugin(pom.getBuildPlugins(), groupId, artifactId);
        }
        if (plugin == null && pom.getReportPlugins() != null) {
            plugin = MavenPlugin.getReportPlugin(pom.getReportPlugins(), groupId, artifactId);
        }
        if (pom.getPluginManagement() != null) {
            Plugin pluginManagement = MavenPlugin.getPlugin(pom.getPluginManagement().getPlugins(), groupId, artifactId);
            if (plugin == null) {
                plugin = pluginManagement;
            } else if (pluginManagement != null) {
                if (pluginManagement.getConfiguration() != null) {
                    if (plugin.getConfiguration() == null) {
                        plugin.setConfiguration(pluginManagement.getConfiguration());
                    } else {
                        Xpp3Dom.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)plugin.getConfiguration()), (Xpp3Dom)((Xpp3Dom)pluginManagement.getConfiguration()));
                    }
                }
                if (plugin.getDependencies() == null && pluginManagement.getDependencies() != null) {
                    plugin.setDependencies(pluginManagement.getDependencies());
                }
                if (plugin.getVersion() == null) {
                    plugin.setVersion(pluginManagement.getVersion());
                }
            }
        }
        if (plugin != null) {
            return new MavenPlugin(plugin);
        }
        return null;
    }

    private static Plugin getPlugin(Collection<Plugin> plugins, String groupId, String artifactId) {
        if (plugins == null) {
            return null;
        }
        for (Plugin plugin : plugins) {
            if (!MavenUtils.equals(plugin, groupId, artifactId)) continue;
            return plugin;
        }
        return null;
    }

    private static Plugin getReportPlugin(Collection<ReportPlugin> plugins, String groupId, String artifactId) {
        if (plugins == null) {
            return null;
        }
        for (ReportPlugin plugin : plugins) {
            if (!MavenUtils.equals(plugin, groupId, artifactId)) continue;
            return MavenPlugin.cloneReportPluginToPlugin(plugin);
        }
        return null;
    }

    private static Plugin cloneReportPluginToPlugin(ReportPlugin reportPlugin) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(reportPlugin.getGroupId());
        plugin.setArtifactId(reportPlugin.getArtifactId());
        plugin.setVersion(reportPlugin.getVersion());
        plugin.setConfiguration(reportPlugin.getConfiguration());
        return plugin;
    }

    private static void unregisterPlugin(MavenProject pom, String groupId, String artifactId) {
        if (pom.getPluginManagement() != null && pom.getPluginManagement().getPlugins() != null) {
            MavenPlugin.unregisterPlugin(pom.getPluginManagement().getPlugins(), groupId, artifactId);
        }
        if (pom.getBuildPlugins() != null && pom.getBuildPlugins() != null) {
            MavenPlugin.unregisterPlugin(pom.getBuildPlugins(), groupId, artifactId);
        }
        if (pom.getReportPlugins() != null) {
            MavenPlugin.unregisterReportPlugin(pom.getReportPlugins(), groupId, artifactId);
        }
    }

    private static void unregisterPlugin(List<Plugin> plugins, String groupId, String artifactId) {
        Iterator<Plugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            Plugin p = iterator.next();
            if (!MavenUtils.equals(p, groupId, artifactId)) continue;
            iterator.remove();
        }
    }

    private static void unregisterReportPlugin(List<ReportPlugin> plugins, String groupId, String artifactId) {
        Iterator<ReportPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            ReportPlugin p = iterator.next();
            if (!MavenUtils.equals(p, groupId, artifactId)) continue;
            iterator.remove();
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("groupId", (Object)this.plugin.getGroupId()).append("artifactId", (Object)this.plugin.getArtifactId()).append("version", (Object)this.plugin.getVersion()).toString();
    }
}

