/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.FieldUtils2;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

public class Checks<C> {
    private final ActiveRules activeRules;
    private final String repository;
    private final Map<RuleKey, C> checkByRule = Maps.newHashMap();
    private final Map<C, RuleKey> ruleByCheck = Maps.newIdentityHashMap();

    Checks(ActiveRules activeRules, String repository) {
        this.activeRules = activeRules;
        this.repository = repository;
    }

    @CheckForNull
    public C of(RuleKey ruleKey) {
        return this.checkByRule.get(ruleKey);
    }

    public Collection<C> all() {
        return this.checkByRule.values();
    }

    @CheckForNull
    public RuleKey ruleKey(C check) {
        return this.ruleByCheck.get(check);
    }

    private void add(RuleKey ruleKey, C obj) {
        this.checkByRule.put(ruleKey, obj);
        this.ruleByCheck.put(obj, ruleKey);
    }

    public Checks<C> addAnnotatedChecks(Object ... checkClassesOrObjects) {
        return this.addAnnotatedChecks(Arrays.asList(checkClassesOrObjects));
    }

    public Checks<C> addAnnotatedChecks(Collection checkClassesOrObjects) {
        String engineKey;
        HashMap checksByEngineKey = Maps.newHashMap();
        for (Object checkClassesOrObject : checkClassesOrObjects) {
            engineKey = this.annotatedEngineKey(checkClassesOrObject);
            if (engineKey == null) continue;
            checksByEngineKey.put(engineKey, checkClassesOrObject);
        }
        for (ActiveRule activeRule : this.activeRules.findByRepository(this.repository)) {
            engineKey = StringUtils.defaultIfBlank((String)activeRule.internalKey(), (String)activeRule.ruleKey().rule());
            Object checkClassesOrObject = checksByEngineKey.get(engineKey);
            Object obj = this.instantiate(activeRule, checkClassesOrObject);
            this.add(activeRule.ruleKey(), obj);
        }
        return this;
    }

    private String annotatedEngineKey(Object annotatedClassOrObject) {
        String key = null;
        Rule ruleAnnotation = AnnotationUtils.getAnnotation(annotatedClassOrObject, Rule.class);
        if (ruleAnnotation != null) {
            key = ruleAnnotation.key();
        }
        Class clazz = annotatedClassOrObject.getClass();
        if (annotatedClassOrObject instanceof Class) {
            clazz = (Class)annotatedClassOrObject;
        }
        return StringUtils.defaultIfEmpty((String)key, (String)clazz.getCanonicalName());
    }

    private Object instantiate(ActiveRule activeRule, Object checkClassOrInstance) {
        try {
            Object check = checkClassOrInstance;
            if (check instanceof Class) {
                check = ((Class)checkClassOrInstance).newInstance();
            }
            this.configureFields(activeRule, check);
            return check;
        }
        catch (InstantiationException e) {
            throw this.failToInstantiateCheck(activeRule, checkClassOrInstance, e);
        }
        catch (IllegalAccessException e) {
            throw this.failToInstantiateCheck(activeRule, checkClassOrInstance, e);
        }
    }

    private RuntimeException failToInstantiateCheck(ActiveRule activeRule, Object checkClassOrInstance, Exception e) {
        throw new IllegalStateException(String.format("Fail to instantiate class %s for rule %s", checkClassOrInstance, activeRule.ruleKey()), e);
    }

    private void configureFields(ActiveRule activeRule, Object check) {
        for (Map.Entry<String, String> param : activeRule.params().entrySet()) {
            Field field = this.getField(check, param.getKey());
            if (field == null) {
                throw new IllegalStateException(String.format("The field '%s' does not exist or is not annotated with @RuleProperty in the class %s", param.getKey(), check.getClass().getName()));
            }
            if (!StringUtils.isNotBlank((String)param.getValue())) continue;
            this.configureField(check, field, param.getValue());
        }
    }

    @CheckForNull
    private Field getField(Object check, String key) {
        List<Field> fields = FieldUtils2.getFields(check.getClass(), true);
        for (Field field : fields) {
            RuleProperty propertyAnnotation = field.getAnnotation(RuleProperty.class);
            if (propertyAnnotation == null || !StringUtils.equals((String)key, (String)field.getName()) && !StringUtils.equals((String)key, (String)propertyAnnotation.key())) continue;
            return field;
        }
        return null;
    }

    private void configureField(Object check, Field field, String value) {
        block13: {
            try {
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(check, value);
                    break block13;
                }
                if ("int".equals(field.getType().getSimpleName())) {
                    field.setInt(check, Integer.parseInt(value));
                    break block13;
                }
                if ("short".equals(field.getType().getSimpleName())) {
                    field.setShort(check, Short.parseShort(value));
                    break block13;
                }
                if ("long".equals(field.getType().getSimpleName())) {
                    field.setLong(check, Long.parseLong(value));
                    break block13;
                }
                if ("double".equals(field.getType().getSimpleName())) {
                    field.setDouble(check, Double.parseDouble(value));
                    break block13;
                }
                if ("boolean".equals(field.getType().getSimpleName())) {
                    field.setBoolean(check, Boolean.parseBoolean(value));
                    break block13;
                }
                if ("byte".equals(field.getType().getSimpleName())) {
                    field.setByte(check, Byte.parseByte(value));
                    break block13;
                }
                if (field.getType().equals(Integer.class)) {
                    field.set(check, Integer.parseInt(value));
                    break block13;
                }
                if (field.getType().equals(Long.class)) {
                    field.set(check, Long.parseLong(value));
                    break block13;
                }
                if (field.getType().equals(Double.class)) {
                    field.set(check, Double.parseDouble(value));
                    break block13;
                }
                if (field.getType().equals(Boolean.class)) {
                    field.set(check, Boolean.parseBoolean(value));
                    break block13;
                }
                throw new SonarException("The type of the field " + field + " is not supported: " + field.getType());
            }
            catch (IllegalAccessException e) {
                throw new SonarException("Can not set the value of the field " + field + " in the class: " + check.getClass().getName(), e);
            }
        }
    }
}

