/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.DefaultActiveRule;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.rule.RuleKey;

@Immutable
public class DefaultActiveRules
implements ActiveRules {
    private final ListMultimap<String, ActiveRule> activeRulesByRepository;
    private final Map<String, Map<String, ActiveRule>> activeRulesByRepositoryAndKey = new HashMap<String, Map<String, ActiveRule>>();
    private final Map<String, Map<String, ActiveRule>> activeRulesByRepositoryAndInternalKey = new HashMap<String, Map<String, ActiveRule>>();
    private final ListMultimap<String, ActiveRule> activeRulesByLanguage;

    public DefaultActiveRules(Collection<NewActiveRule> newActiveRules) {
        ImmutableListMultimap.Builder repoBuilder = ImmutableListMultimap.builder();
        ImmutableListMultimap.Builder langBuilder = ImmutableListMultimap.builder();
        for (NewActiveRule newAR : newActiveRules) {
            DefaultActiveRule ar = new DefaultActiveRule(newAR);
            repoBuilder.put((Object)ar.ruleKey().repository(), (Object)ar);
            if (ar.language() != null) {
                langBuilder.put((Object)ar.language(), (Object)ar);
            }
            if (!this.activeRulesByRepositoryAndKey.containsKey(ar.ruleKey().repository())) {
                this.activeRulesByRepositoryAndKey.put(ar.ruleKey().repository(), new HashMap());
                this.activeRulesByRepositoryAndInternalKey.put(ar.ruleKey().repository(), new HashMap());
            }
            this.activeRulesByRepositoryAndKey.get(ar.ruleKey().repository()).put(ar.ruleKey().rule(), ar);
            String internalKey = ar.internalKey();
            if (internalKey == null) continue;
            this.activeRulesByRepositoryAndInternalKey.get(ar.ruleKey().repository()).put(internalKey, ar);
        }
        this.activeRulesByRepository = repoBuilder.build();
        this.activeRulesByLanguage = langBuilder.build();
    }

    @Override
    public ActiveRule find(RuleKey ruleKey) {
        return this.activeRulesByRepositoryAndKey.containsKey(ruleKey.repository()) ? this.activeRulesByRepositoryAndKey.get(ruleKey.repository()).get(ruleKey.rule()) : null;
    }

    @Override
    public Collection<ActiveRule> findAll() {
        return this.activeRulesByRepository.values();
    }

    @Override
    public Collection<ActiveRule> findByRepository(String repository) {
        return this.activeRulesByRepository.get((Object)repository);
    }

    @Override
    public Collection<ActiveRule> findByLanguage(String language) {
        return this.activeRulesByLanguage.get((Object)language);
    }

    @Override
    public ActiveRule findByInternalKey(String repository, String internalKey) {
        return this.activeRulesByRepositoryAndInternalKey.containsKey(repository) ? this.activeRulesByRepositoryAndInternalKey.get(repository).get(internalKey) : null;
    }
}

