/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Resource;

public final class Library
extends Resource {
    private String name;
    private String description;
    private String version;

    public Library(String key, String version) {
        this.setKey(key);
        this.setDeprecatedKey(key);
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public Library setName(String name) {
        this.name = name;
        return this;
    }

    public Library setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLongName() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Language getLanguage() {
        return null;
    }

    @Override
    public String getScope() {
        return "PRJ";
    }

    @Override
    public String getQualifier() {
        return "LIB";
    }

    @Override
    public Resource getParent() {
        return null;
    }

    @Override
    public boolean matchFilePattern(String antPattern) {
        return false;
    }

    public static Library createFromMavenIds(String groupId, String artifactId, String version) {
        return new Library(String.format("%s:%s", groupId, artifactId), version);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Library library = (Library)o;
        if (!this.getKey().equals(library.getKey())) {
            return false;
        }
        return this.version.equals(library.version);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getKey().hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.getKey()).append("name", (Object)this.getName()).append("version", (Object)this.version).toString();
    }
}

