/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.sonar.api.scan.filesystem.FileType;

@Deprecated
public class FileQuery {
    private final ListMultimap<String, String> attributes = ArrayListMultimap.create();
    private final Set<String> inclusions = Sets.newHashSet();
    private final Set<String> exclusions = Sets.newHashSet();

    public static FileQuery on(FileType ... types) {
        FileQuery query = new FileQuery();
        for (FileType type : types) {
            query.on("TYPE", type.typeValue());
        }
        return query;
    }

    public static FileQuery onSource() {
        return FileQuery.onMain();
    }

    public static FileQuery onMain() {
        FileQuery query = new FileQuery();
        return query.on("TYPE", "MAIN");
    }

    public static FileQuery onTest() {
        FileQuery query = new FileQuery();
        return query.on("TYPE", "TEST");
    }

    private FileQuery() {
    }

    public FileQuery on(String attribute, String ... values) {
        for (String value : values) {
            this.attributes.put((Object)attribute, (Object)value);
        }
        return this;
    }

    public Map<String, Collection<String>> attributes() {
        return this.attributes.asMap();
    }

    public Collection<FileType> types() {
        return Collections2.transform((Collection)this.attributes.get((Object)"TYPE"), (Function)new Function<String, FileType>(){

            public FileType apply(@Nullable String input) {
                return input != null ? FileType.valueOf(input) : null;
            }
        });
    }

    public Collection<String> typeAttributes() {
        return this.attributes.get((Object)"TYPE");
    }

    public Collection<String> languages() {
        return this.attributes.get((Object)"LANG");
    }

    public FileQuery onLanguage(String ... languages) {
        return this.on("LANG", languages);
    }

    public Collection<String> inclusions() {
        return this.inclusions;
    }

    public FileQuery withInclusions(String ... inclusions) {
        this.inclusions.addAll(Arrays.asList(inclusions));
        return this;
    }

    public Collection<String> exclusions() {
        return this.exclusions;
    }

    public FileQuery withExclusions(String ... exclusions) {
        this.exclusions.addAll(Arrays.asList(exclusions));
        return this;
    }

    public Collection<FileFilter> filters() {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FileQuery rhs = (FileQuery)obj;
        return new EqualsBuilder().append(this.attributes, rhs.attributes).append(this.exclusions, rhs.exclusions).append(this.inclusions, rhs.inclusions).isEquals();
    }
}

