/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.PropertyType;

public final class RuleParamType {
    private static final String OPTION_SEPARATOR = ",";
    public static final RuleParamType STRING = new RuleParamType("STRING", new String[0]);
    public static final RuleParamType TEXT = new RuleParamType("TEXT", new String[0]);
    public static final RuleParamType BOOLEAN = new RuleParamType("BOOLEAN", new String[0]);
    public static final RuleParamType INTEGER = new RuleParamType("INTEGER", new String[0]);
    public static final RuleParamType FLOAT = new RuleParamType("FLOAT", new String[0]);
    private static final String CSV_SPLIT_REGEX = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    private static final String VALUES_PARAM = "values";
    private static final String MULTIPLE_PARAM = "multiple";
    private static final String PARAMETER_SEPARATOR = "=";
    private final String type;
    private final List<String> values;
    private final boolean multiple;
    private final String key;

    private RuleParamType(String type, String ... options) {
        this(type, false, options);
    }

    private RuleParamType(String type, boolean multiple, String ... values) {
        this.type = type;
        this.values = Lists.newArrayList((Object[])values);
        StringBuilder sb = new StringBuilder();
        sb.append(type);
        if (multiple) {
            sb.append(OPTION_SEPARATOR);
            sb.append("multiple=");
            sb.append(Boolean.toString(multiple));
        }
        if (values.length > 0) {
            sb.append(OPTION_SEPARATOR);
            sb.append("values=");
            sb.append(StringEscapeUtils.escapeCsv((String)this.valuesToCsv(values)));
        }
        this.key = sb.toString();
        this.multiple = multiple;
    }

    private String valuesToCsv(String ... values) {
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            sb.append(StringEscapeUtils.escapeCsv((String)value));
            sb.append(OPTION_SEPARATOR);
        }
        return sb.toString();
    }

    public String type() {
        return this.type;
    }

    public List<String> values() {
        return this.values;
    }

    public boolean multiple() {
        return this.multiple;
    }

    public static RuleParamType singleListOfValues(String ... acceptedValues) {
        String type = PropertyType.SINGLE_SELECT_LIST.name();
        return new RuleParamType(type, acceptedValues);
    }

    public static RuleParamType multipleListOfValues(String ... acceptedValues) {
        String type = PropertyType.SINGLE_SELECT_LIST.name();
        return new RuleParamType(type, true, acceptedValues);
    }

    public static RuleParamType parse(String s) {
        String[] options;
        if ("i".equals(s) || "i{}".equals(s)) {
            return INTEGER;
        }
        if ("s".equals(s) || "s{}".equals(s) || "r".equals(s) || "REGULAR_EXPRESSION".equals(s)) {
            return STRING;
        }
        if ("b".equals(s)) {
            return BOOLEAN;
        }
        if (s.startsWith("s[")) {
            String values = StringUtils.substringBetween((String)s, (String)"[", (String)"]");
            return RuleParamType.multipleListOfValues(StringUtils.split((String)values, (char)','));
        }
        String format = StringUtils.substringBefore((String)s, (String)OPTION_SEPARATOR);
        String values = null;
        boolean multiple = false;
        for (String option : options = s.split(CSV_SPLIT_REGEX)) {
            String opt = StringEscapeUtils.unescapeCsv((String)option);
            if (opt.startsWith("values=")) {
                values = StringEscapeUtils.unescapeCsv((String)StringUtils.substringAfter((String)opt, (String)"values="));
                continue;
            }
            if (!opt.startsWith("multiple=")) continue;
            multiple = Boolean.parseBoolean(StringUtils.substringAfter((String)opt, (String)"multiple="));
        }
        if (values == null || StringUtils.isBlank(values)) {
            return new RuleParamType(format, new String[0]);
        }
        return new RuleParamType(format, multiple, values.split(CSV_SPLIT_REGEX));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleParamType that = (RuleParamType)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }
}

