/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

public abstract class AbstractSumChildrenDecorator
implements Decorator {
    @DependedUpon
    public abstract List<Metric> generatesMetrics();

    @Override
    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    protected abstract boolean shouldSaveZeroIfNoChildMeasures();

    @Override
    public void decorate(Resource resource, DecoratorContext context) {
        if (!this.shouldDecorateResource(resource)) {
            return;
        }
        for (Metric metric : this.generatesMetrics()) {
            Double sum;
            if (context.getMeasure(metric) != null || (sum = MeasureUtils.sum(this.shouldSaveZeroIfNoChildMeasures(), context.getChildrenMeasures(metric))) == null) continue;
            context.saveMeasure(new Measure(metric, sum));
        }
    }

    public boolean shouldDecorateResource(Resource resource) {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

