/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFilePredicates;
import org.sonar.api.batch.fs.internal.RelativePathPredicate;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.PathUtils;

public class DefaultFileSystem
implements FileSystem {
    private final Cache cache;
    private final SortedSet<String> languages = new TreeSet<String>();
    private File baseDir;
    private File workDir;
    private Charset encoding;
    private final FilePredicates predicates = new DefaultFilePredicates();

    public DefaultFileSystem() {
        this.cache = new MapCache();
    }

    protected DefaultFileSystem(Cache cache) {
        this.cache = cache;
    }

    public DefaultFileSystem setBaseDir(File d) {
        Preconditions.checkNotNull((Object)d, (Object)"Base directory can't be null");
        this.baseDir = d.getAbsoluteFile();
        return this;
    }

    @Override
    public File baseDir() {
        return this.baseDir;
    }

    public DefaultFileSystem setEncoding(@Nullable Charset e) {
        this.encoding = e;
        return this;
    }

    @Override
    public Charset encoding() {
        return this.encoding == null ? Charset.defaultCharset() : this.encoding;
    }

    public boolean isDefaultJvmEncoding() {
        return this.encoding == null;
    }

    public DefaultFileSystem setWorkDir(File d) {
        this.workDir = d.getAbsoluteFile();
        return this;
    }

    @Override
    public File workDir() {
        return this.workDir;
    }

    @Override
    public InputFile inputFile(FilePredicate predicate) {
        this.doPreloadFiles();
        if (predicate instanceof RelativePathPredicate) {
            return this.cache.inputFile((RelativePathPredicate)predicate);
        }
        Iterable<InputFile> files = this.inputFiles(predicate);
        Iterator<InputFile> iterator = files.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        InputFile first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("expected one element but was: <" + first);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            sb.append(", " + iterator.next());
        }
        if (iterator.hasNext()) {
            sb.append(", ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(sb.toString());
    }

    @Override
    public Iterable<InputFile> inputFiles(FilePredicate predicate) {
        this.doPreloadFiles();
        return DefaultFileSystem.filter(this.cache.inputFiles(), predicate);
    }

    @Override
    public boolean hasFiles(FilePredicate predicate) {
        this.doPreloadFiles();
        for (InputFile element : this.cache.inputFiles()) {
            if (!predicate.apply(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<File> files(FilePredicate predicate) {
        this.doPreloadFiles();
        ArrayList<File> result = new ArrayList<File>();
        for (InputFile element : this.inputFiles(predicate)) {
            if (!predicate.apply(element)) continue;
            result.add(element.file());
        }
        return result;
    }

    @Override
    public InputDir inputDir(File dir) {
        this.doPreloadFiles();
        String relativePath = PathUtils.sanitize(new PathResolver().relativePath(this.baseDir, dir));
        if (relativePath == null) {
            return null;
        }
        return this.cache.inputDir(relativePath);
    }

    public static Collection<InputFile> filter(Iterable<InputFile> target, FilePredicate predicate) {
        ArrayList<InputFile> result = new ArrayList<InputFile>();
        for (InputFile element : target) {
            if (!predicate.apply(element)) continue;
            result.add(element);
        }
        return result;
    }

    public synchronized DefaultFileSystem add(InputFile inputFile) {
        this.cache.add(inputFile);
        if (inputFile.language() != null) {
            this.languages.add(inputFile.language());
        }
        return this;
    }

    public synchronized DefaultFileSystem add(InputDir inputDir) {
        this.cache.add(inputDir);
        return this;
    }

    public DefaultFileSystem addLanguages(String language, String ... others) {
        this.languages.add(language);
        Collections.addAll(this.languages, others);
        return this;
    }

    @Override
    public SortedSet<String> languages() {
        this.doPreloadFiles();
        return this.languages;
    }

    @Override
    public FilePredicates predicates() {
        return this.predicates;
    }

    protected void doPreloadFiles() {
    }

    @Override
    public File resolvePath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            try {
                file = new File(this.baseDir(), path).getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to resolve path '" + path + "'", e);
            }
        }
        return file;
    }

    private static class MapCache
    extends Cache {
        private final Map<String, InputFile> fileMap = new HashMap<String, InputFile>();
        private final Map<String, InputDir> dirMap = new HashMap<String, InputDir>();

        private MapCache() {
        }

        @Override
        public Iterable<InputFile> inputFiles() {
            return new ArrayList<InputFile>(this.fileMap.values());
        }

        @Override
        public InputFile inputFile(RelativePathPredicate predicate) {
            return this.fileMap.get(predicate.path());
        }

        @Override
        protected InputDir inputDir(String relativePath) {
            return this.dirMap.get(relativePath);
        }

        @Override
        protected void doAdd(InputFile inputFile) {
            this.fileMap.put(inputFile.relativePath(), inputFile);
        }

        @Override
        protected void doAdd(InputDir inputDir) {
            this.dirMap.put(inputDir.relativePath(), inputDir);
        }
    }

    public static abstract class Cache {
        protected abstract Iterable<InputFile> inputFiles();

        @CheckForNull
        protected abstract InputFile inputFile(RelativePathPredicate var1);

        @CheckForNull
        protected abstract InputDir inputDir(String var1);

        protected abstract void doAdd(InputFile var1);

        protected abstract void doAdd(InputDir var1);

        final void add(InputFile inputFile) {
            this.doAdd(inputFile);
        }

        public void add(InputDir inputDir) {
            this.doAdd(inputDir);
        }
    }
}

