/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.Serializable;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.utils.PathUtils;

public class DefaultInputDir
implements InputDir,
Serializable {
    private final String relativePath;
    private final String moduleKey;
    private String absolutePath;

    public DefaultInputDir(String moduleKey, String relativePath) {
        this.moduleKey = moduleKey;
        this.relativePath = PathUtils.sanitize(relativePath);
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    public String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public File file() {
        if (this.absolutePath == null) {
            throw new IllegalStateException("Can not return the java.io.File because absolute path is not set (see method setFile(java.io.File))");
        }
        return new File(this.absolutePath);
    }

    public String moduleKey() {
        return this.moduleKey;
    }

    public String key() {
        return this.moduleKey + ":" + this.relativePath;
    }

    public DefaultInputDir setAbsolutePath(String s) {
        this.absolutePath = PathUtils.sanitize(s);
        return this;
    }

    public DefaultInputDir setFile(File file) {
        this.setAbsolutePath(file.getAbsolutePath());
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultInputDir)) {
            return false;
        }
        DefaultInputDir that = (DefaultInputDir)o;
        return this.moduleKey.equals(that.moduleKey) && this.relativePath.equals(that.relativePath);
    }

    public int hashCode() {
        return this.moduleKey.hashCode() + this.relativePath.hashCode() * 13;
    }

    public String toString() {
        return "[moduleKey=" + this.moduleKey + ", relative=" + this.relativePath + ", abs=" + this.absolutePath + "]";
    }
}

