/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.Serializable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.PathUtils;

public class DefaultInputFile
implements InputFile,
Serializable {
    private final String relativePath;
    private final String moduleKey;
    private String absolutePath;
    private String language;
    private InputFile.Type type = InputFile.Type.MAIN;
    private InputFile.Status status;
    private String hash;
    private int lines;
    private String encoding;
    long[] originalLineOffsets;
    byte[][] lineHashes;

    public DefaultInputFile(String moduleKey, String relativePath) {
        this.moduleKey = moduleKey;
        this.relativePath = PathUtils.sanitize(relativePath);
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    public String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public File file() {
        if (this.absolutePath == null) {
            throw new IllegalStateException("Can not return the java.io.File because absolute path is not set (see method setFile(java.io.File))");
        }
        return new File(this.absolutePath);
    }

    @Override
    public String language() {
        return this.language;
    }

    @Override
    public InputFile.Type type() {
        return this.type;
    }

    @Override
    public InputFile.Status status() {
        return this.status;
    }

    public String hash() {
        return this.hash;
    }

    @Override
    public int lines() {
        return this.lines;
    }

    public String key() {
        return this.moduleKey + ":" + this.relativePath;
    }

    public String moduleKey() {
        return this.moduleKey;
    }

    public String encoding() {
        return this.encoding;
    }

    public long[] originalLineOffsets() {
        return this.originalLineOffsets;
    }

    public byte[][] lineHashes() {
        return this.lineHashes;
    }

    public DefaultInputFile setAbsolutePath(String s) {
        this.absolutePath = PathUtils.sanitize(s);
        return this;
    }

    public DefaultInputFile setLanguage(String language) {
        this.language = language;
        return this;
    }

    public DefaultInputFile setFile(File file) {
        this.setAbsolutePath(file.getAbsolutePath());
        return this;
    }

    public DefaultInputFile setType(InputFile.Type type) {
        this.type = type;
        return this;
    }

    public DefaultInputFile setStatus(InputFile.Status status) {
        this.status = status;
        return this;
    }

    public DefaultInputFile setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public DefaultInputFile setLines(int lines) {
        this.lines = lines;
        return this;
    }

    public DefaultInputFile setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public DefaultInputFile setOriginalLineOffsets(long[] originalLineOffsets) {
        this.originalLineOffsets = originalLineOffsets;
        return this;
    }

    public DefaultInputFile setLineHashes(byte[][] lineHashes) {
        this.lineHashes = lineHashes;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultInputFile)) {
            return false;
        }
        DefaultInputFile that = (DefaultInputFile)o;
        return this.moduleKey.equals(that.moduleKey) && this.relativePath.equals(that.relativePath);
    }

    public int hashCode() {
        return this.moduleKey.hashCode() + this.relativePath.hashCode() * 13;
    }

    public String toString() {
        return "[moduleKey=" + this.moduleKey + ", relative=" + this.relativePath + ", abs=" + this.absolutePath + "]";
    }
}

