/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.dependency.internal;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorStorage;
import org.sonar.api.batch.sensor.dependency.Dependency;
import org.sonar.api.batch.sensor.internal.DefaultStorable;

public class DefaultDependency
extends DefaultStorable
implements Dependency {
    private InputFile from;
    private InputFile to;
    private int weight = 1;

    public DefaultDependency() {
        super(null);
    }

    public DefaultDependency(@Nullable SensorStorage storage) {
        super(storage);
    }

    @Override
    public Dependency from(InputFile from) {
        Preconditions.checkNotNull((Object)from, (Object)"InputFile should be non null");
        this.from = from;
        return this;
    }

    @Override
    public Dependency to(InputFile to) {
        Preconditions.checkNotNull((Object)to, (Object)"InputFile should be non null");
        this.to = to;
        return this;
    }

    @Override
    public Dependency weight(int weight) {
        Preconditions.checkArgument((weight > 1 ? 1 : 0) != 0, (Object)"weight should be greater than 1");
        this.weight = weight;
        return this;
    }

    @Override
    public void doSave() {
        Preconditions.checkState((!this.from.equals(this.to) ? 1 : 0) != 0, (Object)"From and To can't be the same inputFile");
        Preconditions.checkNotNull((Object)this.from, (Object)"From inputFile can't be null");
        Preconditions.checkNotNull((Object)this.to, (Object)"To inputFile can't be null");
        this.storage.store(this);
    }

    @Override
    public InputFile from() {
        return this.from;
    }

    @Override
    public InputFile to() {
        return this.to;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultDependency rhs = (DefaultDependency)obj;
        return new EqualsBuilder().append((Object)this.from, (Object)rhs.from).append((Object)this.to, (Object)rhs.to).append(this.weight, rhs.weight).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(27, 45).append((Object)this.from).append((Object)this.to).append(this.weight).toHashCode();
    }
}

