/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.duplication;

import com.google.common.annotations.Beta;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@Beta
public class DuplicationGroup {
    private final Block originBlock;
    private List<Block> duplicates = new LinkedList<Block>();

    public DuplicationGroup(Block originBlock) {
        this.originBlock = originBlock;
    }

    public void setDuplicates(List<Block> duplicates) {
        this.duplicates = duplicates;
    }

    public DuplicationGroup addDuplicate(Block anotherBlock) {
        this.duplicates.add(anotherBlock);
        return this;
    }

    public Block originBlock() {
        return this.originBlock;
    }

    public List<Block> duplicates() {
        return this.duplicates;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DuplicationGroup rhs = (DuplicationGroup)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder().append((Object)this.originBlock, (Object)rhs.originBlock).append(this.duplicates.size(), rhs.duplicates.size());
        if (this.duplicates.size() == rhs.duplicates.size()) {
            for (int i = 0; i < this.duplicates.size(); ++i) {
                equalsBuilder.append((Object)this.duplicates.get(i), (Object)rhs.duplicates.get(i));
            }
        }
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hcBuilder = new HashCodeBuilder(17, 37).append((Object)this.originBlock).append(this.duplicates.size());
        for (int i = 0; i < this.duplicates.size(); ++i) {
            hcBuilder.append((Object)this.duplicates.get(i));
        }
        return hcBuilder.toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("origin", (Object)this.originBlock).append("duplicates", this.duplicates, true).toString();
    }

    public static class Block {
        private final String resourceKey;
        private final int startLine;
        private final int length;

        public Block(String resourceKey, int startLine, int length) {
            this.resourceKey = resourceKey;
            this.startLine = startLine;
            this.length = length;
        }

        public String resourceKey() {
            return this.resourceKey;
        }

        public int startLine() {
            return this.startLine;
        }

        public int length() {
            return this.length;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Block rhs = (Block)obj;
            return new EqualsBuilder().append((Object)this.resourceKey, (Object)rhs.resourceKey).append(this.startLine, rhs.startLine).append(this.length, rhs.length).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(13, 43).append((Object)this.resourceKey).append(this.startLine).append(this.length).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("resourceKey", (Object)this.resourceKey).append("startLine", this.startLine).append("length", this.length).toString();
        }
    }
}

