/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.sensor.SensorStorage;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.internal.Uuids;

public class DefaultIssue
extends DefaultStorable
implements Issue {
    private static final String INPUT_DIR_SHOULD_BE_NON_NULL = "InputDir should be non null";
    private static final String INPUT_FILE_SHOULD_BE_NON_NULL = "InputFile should be non null";
    private static final String ON_FILE_OR_ON_DIR_ALREADY_CALLED = "onFile or onDir already called";
    private static final String ON_PROJECT_ALREADY_CALLED = "onProject already called";
    private String key = Uuids.create();
    private boolean onProject = false;
    private InputPath path;
    private RuleKey ruleKey;
    private String message;
    private Integer line;
    private Double effortToFix;
    private Issue.Severity overridenSeverity;

    public DefaultIssue() {
        super(null);
    }

    public DefaultIssue(SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultIssue ruleKey(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @Override
    public DefaultIssue onFile(InputFile file) {
        Preconditions.checkState((!this.onProject ? 1 : 0) != 0, (Object)ON_PROJECT_ALREADY_CALLED);
        Preconditions.checkState((this.path == null ? 1 : 0) != 0, (Object)ON_FILE_OR_ON_DIR_ALREADY_CALLED);
        Preconditions.checkNotNull((Object)file, (Object)INPUT_FILE_SHOULD_BE_NON_NULL);
        this.path = file;
        return this;
    }

    @Override
    public DefaultIssue onDir(InputDir dir) {
        Preconditions.checkState((!this.onProject ? 1 : 0) != 0, (Object)ON_PROJECT_ALREADY_CALLED);
        Preconditions.checkState((this.path == null ? 1 : 0) != 0, (Object)ON_FILE_OR_ON_DIR_ALREADY_CALLED);
        Preconditions.checkNotNull((Object)dir, (Object)INPUT_DIR_SHOULD_BE_NON_NULL);
        this.path = dir;
        return this;
    }

    @Override
    public DefaultIssue onProject() {
        Preconditions.checkState((!this.onProject ? 1 : 0) != 0, (Object)ON_PROJECT_ALREADY_CALLED);
        Preconditions.checkState((this.path == null ? 1 : 0) != 0, (Object)ON_FILE_OR_ON_DIR_ALREADY_CALLED);
        this.onProject = true;
        return this;
    }

    @Override
    public DefaultIssue atLine(int line) {
        Preconditions.checkState((this.path != null && this.path instanceof InputFile ? 1 : 0) != 0, (Object)"atLine should be called after onFile");
        this.line = line;
        return this;
    }

    @Override
    public DefaultIssue effortToFix(@Nullable Double effortToFix) {
        this.effortToFix = effortToFix;
        return this;
    }

    @Override
    public DefaultIssue message(String message) {
        this.message = message;
        return this;
    }

    @Override
    public Issue overrideSeverity(@Nullable Issue.Severity severity) {
        this.overridenSeverity = severity;
        return this;
    }

    @Override
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    @Override
    @CheckForNull
    public InputPath inputPath() {
        return this.path;
    }

    @Override
    public Integer line() {
        return this.line;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public Issue.Severity overridenSeverity() {
        return this.overridenSeverity;
    }

    @Override
    public Double effortToFix() {
        return this.effortToFix;
    }

    public String key() {
        return this.key;
    }

    @Override
    public void doSave() {
        Preconditions.checkNotNull((Object)this.ruleKey, (Object)"ruleKey is mandatory on issue");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.key) ? 1 : 0) != 0, (Object)"Fail to generate issue key");
        this.storage.store(this);
    }

    public DefaultIssue withKey(String key) {
        this.key = key;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIssue that = (DefaultIssue)o;
        return !this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

