/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.test;

import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.measures.CoreMetrics;

public interface Coverage {
    public Coverage onFile(InputFile var1);

    public Coverage ofType(CoverageType var1);

    public Coverage lineHits(int var1, int var2);

    public Coverage conditions(int var1, int var2, int var3);

    public void save();

    public static enum CoverageType {
        UNIT(CoreMetrics.LINES_TO_COVER, CoreMetrics.UNCOVERED_LINES, CoreMetrics.COVERAGE_LINE_HITS_DATA, CoreMetrics.CONDITIONS_TO_COVER, CoreMetrics.UNCOVERED_CONDITIONS, CoreMetrics.CONDITIONS_BY_LINE, CoreMetrics.COVERED_CONDITIONS_BY_LINE),
        INTEGRATION(CoreMetrics.IT_LINES_TO_COVER, CoreMetrics.IT_UNCOVERED_LINES, CoreMetrics.IT_COVERAGE_LINE_HITS_DATA, CoreMetrics.IT_CONDITIONS_TO_COVER, CoreMetrics.IT_UNCOVERED_CONDITIONS, CoreMetrics.IT_CONDITIONS_BY_LINE, CoreMetrics.IT_COVERED_CONDITIONS_BY_LINE),
        OVERALL(CoreMetrics.OVERALL_LINES_TO_COVER, CoreMetrics.OVERALL_UNCOVERED_LINES, CoreMetrics.OVERALL_COVERAGE_LINE_HITS_DATA, CoreMetrics.OVERALL_CONDITIONS_TO_COVER, CoreMetrics.OVERALL_UNCOVERED_CONDITIONS, CoreMetrics.OVERALL_CONDITIONS_BY_LINE, CoreMetrics.OVERALL_COVERED_CONDITIONS_BY_LINE);

        private Metric<Integer> linesToCover;
        private Metric<Integer> uncoveredLines;
        private Metric<String> lineHitsData;
        private Metric<Integer> conditionsToCover;
        private Metric<Integer> uncoveredConditions;
        private Metric<String> conditionsByLine;
        private Metric<String> coveredConditionsByLine;

        private CoverageType(Metric<Integer> linesToCover, Metric<Integer> uncoveredLines, Metric<String> lineHitsData, Metric<Integer> conditionsToCover, Metric<Integer> uncoveredConditions, Metric<String> conditionsByLine, Metric<String> coveredConditionsByLine) {
            this.linesToCover = linesToCover;
            this.uncoveredLines = uncoveredLines;
            this.lineHitsData = lineHitsData;
            this.conditionsToCover = conditionsToCover;
            this.uncoveredConditions = uncoveredConditions;
            this.conditionsByLine = conditionsByLine;
            this.coveredConditionsByLine = coveredConditionsByLine;
        }

        public Metric<Integer> linesToCover() {
            return this.linesToCover;
        }

        public Metric<Integer> uncoveredLines() {
            return this.uncoveredLines;
        }

        public Metric<String> lineHitsData() {
            return this.lineHitsData;
        }

        public Metric<Integer> conditionsToCover() {
            return this.conditionsToCover;
        }

        public Metric<Integer> uncoveredConditions() {
            return this.uncoveredConditions;
        }

        public Metric<String> conditionsByLine() {
            return this.conditionsByLine;
        }

        public Metric<String> coveredConditionsByLine() {
            return this.coveredConditionsByLine;
        }
    }
}

