/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.test.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.SortedMap;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.SensorStorage;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.batch.sensor.test.Coverage;
import org.sonar.api.utils.KeyValueFormat;

public final class DefaultCoverage
implements Coverage {
    private static final String INPUT_FILE_SHOULD_BE_NON_NULL = "InputFile should be non null";
    private InputFile file;
    private Coverage.CoverageType type;
    private int totalCoveredLines = 0;
    private int totalConditions = 0;
    private int totalCoveredConditions = 0;
    private SortedMap<Integer, Integer> hitsByLine = Maps.newTreeMap();
    private SortedMap<Integer, Integer> conditionsByLine = Maps.newTreeMap();
    private SortedMap<Integer, Integer> coveredConditionsByLine = Maps.newTreeMap();
    protected final transient SensorStorage storage;
    private transient boolean saved = false;

    public DefaultCoverage() {
        this.storage = null;
    }

    public DefaultCoverage(SensorStorage storage) {
        this.storage = storage;
    }

    @Override
    public DefaultCoverage lineHits(int lineId, int hits) {
        Preconditions.checkArgument((lineId >= 1 ? 1 : 0) != 0, (Object)("Line number should be positive and non zero [" + this.file.relativePath() + ":" + lineId + "]"));
        Preconditions.checkArgument((hits >= 0 ? 1 : 0) != 0, (Object)("Hits should be positive [" + this.file.relativePath() + ":" + lineId + "]"));
        Preconditions.checkArgument((!this.hitsByLine.containsKey(lineId) ? 1 : 0) != 0, (Object)("Hits already saved on line [" + this.file.relativePath() + ":" + lineId + "]"));
        this.hitsByLine.put(lineId, hits);
        if (hits > 0) {
            ++this.totalCoveredLines;
        }
        return this;
    }

    @Override
    public DefaultCoverage conditions(int lineId, int conditions, int coveredConditions) {
        Preconditions.checkArgument((lineId >= 1 ? 1 : 0) != 0, (Object)("Line number should be positive and non zero [" + this.file.relativePath() + ":" + lineId + "]"));
        Preconditions.checkArgument((conditions >= 0 ? 1 : 0) != 0, (Object)("Number of conditions should be positive [" + this.file.relativePath() + ":" + lineId + "]"));
        Preconditions.checkArgument((coveredConditions >= 0 ? 1 : 0) != 0, (Object)("Number of covered conditions should be positive [" + this.file.relativePath() + ":" + lineId + "]"));
        Preconditions.checkArgument((conditions >= coveredConditions ? 1 : 0) != 0, (Object)("Number of covered conditions can't exceed conditions [" + this.file.relativePath() + ":" + lineId + "]"));
        Preconditions.checkArgument((!this.conditionsByLine.containsKey(lineId) ? 1 : 0) != 0, (Object)("Conditions already saved on line [" + this.file.relativePath() + ":" + lineId + "]"));
        this.totalConditions += conditions;
        this.totalCoveredConditions += coveredConditions;
        this.conditionsByLine.put(lineId, conditions);
        this.coveredConditionsByLine.put(lineId, coveredConditions);
        return this;
    }

    public InputFile file() {
        return this.file;
    }

    @Override
    public DefaultCoverage onFile(InputFile inputFile) {
        Preconditions.checkNotNull((Object)inputFile, (Object)INPUT_FILE_SHOULD_BE_NON_NULL);
        Preconditions.checkArgument((inputFile.type() == InputFile.Type.MAIN ? 1 : 0) != 0, (Object)("Coverage is only supported on main files [" + inputFile.relativePath() + "]"));
        this.file = inputFile;
        return this;
    }

    public Coverage.CoverageType type() {
        return this.type;
    }

    @Override
    public DefaultCoverage ofType(Coverage.CoverageType type) {
        Preconditions.checkNotNull((Object)((Object)type));
        this.type = type;
        return this;
    }

    @Override
    public void save() {
        Preconditions.checkNotNull((Object)this.storage, (Object)"No persister on this object");
        Preconditions.checkState((!this.saved ? 1 : 0) != 0, (Object)"This object was already saved");
        Preconditions.checkNotNull((Object)this.file, (Object)"File is mandatory on Coverage");
        Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Type is mandatory on Coverage");
        if (!this.hitsByLine.isEmpty()) {
            ((DefaultStorable)((Object)((DefaultMeasure)((DefaultMeasure)new DefaultMeasure(this.storage).onFile(this.file)).forMetric((Metric)this.type.linesToCover())).withValue(Integer.valueOf(this.hitsByLine.size())))).save();
            ((DefaultStorable)((Object)((DefaultMeasure)((DefaultMeasure)new DefaultMeasure(this.storage).onFile(this.file)).forMetric((Metric)this.type.uncoveredLines())).withValue(Integer.valueOf(this.hitsByLine.size() - this.totalCoveredLines)))).save();
            ((DefaultStorable)((Object)((DefaultMeasure)((DefaultMeasure)new DefaultMeasure(this.storage).onFile(this.file)).forMetric((Metric)this.type.lineHitsData())).withValue((Serializable)((Object)KeyValueFormat.format(this.hitsByLine))))).save();
        }
        if (this.totalConditions > 0) {
            ((DefaultStorable)((Object)((DefaultMeasure)((DefaultMeasure)new DefaultMeasure(this.storage).onFile(this.file)).forMetric((Metric)this.type.conditionsToCover())).withValue(Integer.valueOf(this.totalConditions)))).save();
            ((DefaultStorable)((Object)((DefaultMeasure)((DefaultMeasure)new DefaultMeasure(this.storage).onFile(this.file)).forMetric((Metric)this.type.uncoveredConditions())).withValue(Integer.valueOf(this.totalConditions - this.totalCoveredConditions)))).save();
            ((DefaultStorable)((Object)((DefaultMeasure)((DefaultMeasure)new DefaultMeasure(this.storage).onFile(this.file)).forMetric((Metric)this.type.coveredConditionsByLine())).withValue((Serializable)((Object)KeyValueFormat.format(this.coveredConditionsByLine))))).save();
            ((DefaultStorable)((Object)((DefaultMeasure)((DefaultMeasure)new DefaultMeasure(this.storage).onFile(this.file)).forMetric((Metric)this.type.conditionsByLine())).withValue((Serializable)((Object)KeyValueFormat.format(this.conditionsByLine))))).save();
        }
        this.saved = true;
    }
}

