/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.test.internal;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorStorage;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.test.TestCaseCoverage;

public class DefaultTestCaseCoverage
extends DefaultStorable
implements TestCaseCoverage {
    private InputFile testFile;
    private InputFile mainFile;
    private String name;
    private List<Integer> lines;

    public DefaultTestCaseCoverage() {
        super(null);
    }

    public DefaultTestCaseCoverage(SensorStorage storage) {
        super(storage);
    }

    @Override
    public InputFile testFile() {
        return this.testFile;
    }

    @Override
    public DefaultTestCaseCoverage testFile(InputFile testFile) {
        Preconditions.checkNotNull((Object)testFile, (Object)"TestFile cannot be null");
        Preconditions.checkArgument((testFile.type() == InputFile.Type.TEST ? 1 : 0) != 0, (Object)("Should be a test file: " + testFile));
        this.testFile = testFile;
        return this;
    }

    @Override
    public InputFile coveredFile() {
        return this.mainFile;
    }

    @Override
    public DefaultTestCaseCoverage cover(InputFile mainFile) {
        Preconditions.checkNotNull((Object)mainFile, (Object)"InputFile cannot be null");
        Preconditions.checkArgument((mainFile.type() == InputFile.Type.MAIN ? 1 : 0) != 0, (Object)("Should be a main file: " + mainFile));
        this.mainFile = mainFile;
        return this;
    }

    @Override
    public DefaultTestCaseCoverage testName(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Test name is mandatory and should not be blank");
        this.name = name;
        return this;
    }

    @Override
    public String testName() {
        return this.name;
    }

    @Override
    public List<Integer> coveredLines() {
        return Collections.unmodifiableList(this.lines);
    }

    @Override
    public DefaultTestCaseCoverage onLines(List<Integer> lines) {
        Preconditions.checkNotNull(lines, (Object)"Lines list cannot be null");
        Preconditions.checkArgument((!lines.isEmpty() ? 1 : 0) != 0, (Object)"No need to register test coverage if no line is covered");
        this.lines = lines;
        return this;
    }

    @Override
    public void doSave() {
        Preconditions.checkNotNull((Object)this.testFile, (Object)"TestFile is mandatory");
        Preconditions.checkNotNull((Object)this.mainFile, (Object)"MainFile is mandatory");
        Preconditions.checkNotNull((Object)this.name, (Object)"Test name is mandatory");
        Preconditions.checkNotNull(this.lines, (Object)"Lines are mandatory");
        this.storage.store(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultTestCaseCoverage rhs = (DefaultTestCaseCoverage)obj;
        return new EqualsBuilder().append((Object)this.testFile, (Object)rhs.testFile).append((Object)this.name, (Object)rhs.name).append((Object)this.mainFile, (Object)rhs.mainFile).append(this.lines.toArray(), rhs.lines.toArray()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 43).append((Object)this.testFile).append((Object)this.name).append((Object)this.mainFile).toHashCode();
    }
}

