/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.test.internal;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorStorage;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.test.TestCaseExecution;

public class DefaultTestCaseExecution
extends DefaultStorable
implements TestCaseExecution {
    private InputFile testFile;
    private String name;
    private Long duration;
    private TestCaseExecution.Status status = TestCaseExecution.Status.OK;
    private String message;
    private TestCaseExecution.Type type = TestCaseExecution.Type.UNIT;
    private String stackTrace;

    public DefaultTestCaseExecution() {
        super(null);
    }

    public DefaultTestCaseExecution(SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultTestCaseExecution inTestFile(InputFile testFile) {
        Preconditions.checkNotNull((Object)testFile, (Object)"TestFile cannot be null");
        Preconditions.checkArgument((testFile.type() == InputFile.Type.TEST ? 1 : 0) != 0, (Object)("Should be a test file: " + testFile));
        this.testFile = testFile;
        return this;
    }

    @Override
    public DefaultTestCaseExecution name(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Test name is mandatory and should not be blank");
        this.name = name;
        return this;
    }

    @Override
    public DefaultTestCaseExecution durationInMs(long duration) {
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (Object)("Test duration must be positive (got: " + duration + ")"));
        this.duration = duration;
        return this;
    }

    @Override
    public DefaultTestCaseExecution status(TestCaseExecution.Status status) {
        Preconditions.checkNotNull((Object)((Object)status));
        this.status = status;
        return this;
    }

    @Override
    public DefaultTestCaseExecution message(@Nullable String message) {
        this.message = message;
        return this;
    }

    @Override
    public DefaultTestCaseExecution ofType(TestCaseExecution.Type type) {
        Preconditions.checkNotNull((Object)((Object)type));
        this.type = type;
        return this;
    }

    @Override
    public DefaultTestCaseExecution stackTrace(@Nullable String stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }

    @Override
    public InputFile testFile() {
        return this.testFile;
    }

    @Override
    @CheckForNull
    public Long durationInMs() {
        return this.duration;
    }

    @Override
    public TestCaseExecution.Type type() {
        return this.type;
    }

    @Override
    public TestCaseExecution.Status status() {
        return this.status;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @CheckForNull
    public String message() {
        return this.message;
    }

    @Override
    @CheckForNull
    public String stackTrace() {
        return this.stackTrace;
    }

    @Override
    public void doSave() {
        Preconditions.checkNotNull((Object)this.testFile, (Object)"TestFile is mandatory");
        Preconditions.checkNotNull((Object)this.name, (Object)"Test name is mandatory");
        this.storage.store(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultTestCaseExecution rhs = (DefaultTestCaseExecution)obj;
        return new EqualsBuilder().append((Object)this.testFile, (Object)rhs.testFile).append((Object)this.name, (Object)rhs.name).append((Object)this.duration, (Object)rhs.duration).append((Object)this.status, (Object)rhs.status).append((Object)this.message, (Object)rhs.message).append((Object)this.type, (Object)rhs.type).append((Object)this.stackTrace, (Object)rhs.stackTrace).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 43).append((Object)this.testFile).append((Object)this.name).append((Object)this.duration).append((Object)this.status).append((Object)this.message).append((Object)this.type).append((Object)this.stackTrace).toHashCode();
    }
}

