/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws.internal;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.WebService;

public abstract class ValidatingRequest
extends Request {
    private WebService.Action action;

    public void setAction(WebService.Action action) {
        this.action = action;
    }

    public WebService.Action action() {
        return this.action;
    }

    @Override
    @CheckForNull
    public String param(String key) {
        return this.param(key, true);
    }

    @CheckForNull
    private String param(String key, boolean validateValue) {
        WebService.Param definition = this.action.param(key);
        String value = this.readParamOrDefaultValue(key, definition);
        if (value != null && validateValue) {
            this.validate(value, definition);
        }
        return value;
    }

    @Override
    @CheckForNull
    public List<String> paramAsStrings(String key) {
        WebService.Param definition = this.action.param(key);
        String value = this.readParamOrDefaultValue(key, definition);
        if (value == null) {
            return null;
        }
        ArrayList values = Lists.newArrayList((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value));
        for (String s : values) {
            this.validate(s, definition);
        }
        return values;
    }

    @Override
    @CheckForNull
    public <E extends Enum<E>> List<E> paramAsEnums(String key, Class<E> enumClass) {
        WebService.Param definition = this.action.param(key);
        String value = this.readParamOrDefaultValue(key, definition);
        if (value == null) {
            return null;
        }
        Iterable values = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value);
        ArrayList result = Lists.newArrayList();
        for (String s : values) {
            this.validate(s, definition);
            result.add(Enum.valueOf(enumClass, s));
        }
        return result;
    }

    @CheckForNull
    private String readParamOrDefaultValue(String key, @Nullable WebService.Param definition) {
        if (definition == null) {
            String message = String.format("BUG - parameter '%s' is undefined for action '%s'", key, this.action.key());
            LoggerFactory.getLogger(this.getClass()).error(message);
            throw new IllegalArgumentException(message);
        }
        String deprecatedKey = definition.deprecatedKey();
        String value = deprecatedKey != null ? StringUtils.defaultString((String)this.readParam(deprecatedKey), (String)this.readParam(key)) : this.readParam(key);
        if ((value = StringUtils.defaultString((String)value, (String)definition.defaultValue())) == null) {
            return null;
        }
        return value;
    }

    @CheckForNull
    protected abstract String readParam(String var1);

    private void validate(String value, WebService.Param definition) {
        Set<String> possibleValues = definition.possibleValues();
        if (possibleValues != null && !possibleValues.contains(value)) {
            throw new IllegalArgumentException(String.format("Value of parameter '%s' (%s) must be one of: %s", definition.key(), value, possibleValues));
        }
    }
}

