/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.command;

import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.command.Command;
import org.sonar.api.utils.command.CommandException;
import org.sonar.api.utils.command.StreamConsumer;
import org.sonar.api.utils.command.TimeoutException;

public class CommandExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CommandExecutor.class);
    private static final CommandExecutor INSTANCE = new CommandExecutor();

    private CommandExecutor() {
    }

    public static CommandExecutor create() {
        return INSTANCE;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(Command command, StreamConsumer stdOut, StreamConsumer stdErr, long timeoutMilliseconds) {
        int n;
        ExecutorService executorService = null;
        Process process = null;
        StreamGobbler outputGobbler = null;
        StreamGobbler errorGobbler = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(command.toStrings(false));
            if (command.getDirectory() != null) {
                builder.directory(command.getDirectory());
            }
            builder.environment().putAll(command.getEnvironmentVariables());
            process = builder.start();
            outputGobbler = new StreamGobbler(process.getInputStream(), stdOut);
            errorGobbler = new StreamGobbler(process.getErrorStream(), stdErr);
            outputGobbler.start();
            errorGobbler.start();
            final Process finalProcess = process;
            executorService = Executors.newSingleThreadExecutor();
            Future<Integer> ft = executorService.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return finalProcess.waitFor();
                }
            });
            int exitCode = timeoutMilliseconds < 0L ? ft.get().intValue() : ft.get(timeoutMilliseconds, TimeUnit.MILLISECONDS).intValue();
            this.waitUntilFinish(outputGobbler);
            this.waitUntilFinish(errorGobbler);
            this.verifyGobbler(command, outputGobbler, "stdOut");
            this.verifyGobbler(command, errorGobbler, "stdErr");
            n = exitCode;
        }
        catch (java.util.concurrent.TimeoutException te) {
            try {
                process.destroy();
                throw new TimeoutException(command, "Timeout exceeded: " + timeoutMilliseconds + " ms", te);
                catch (CommandException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CommandException(command, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.waitUntilFinish(outputGobbler);
                this.waitUntilFinish(errorGobbler);
                this.closeStreams(process);
                if (executorService != null) {
                    executorService.shutdown();
                }
                throw throwable;
            }
        }
        this.waitUntilFinish(outputGobbler);
        this.waitUntilFinish(errorGobbler);
        this.closeStreams(process);
        if (executorService != null) {
            executorService.shutdown();
        }
        return n;
    }

    private void verifyGobbler(Command command, StreamGobbler gobbler, String type) {
        if (gobbler.getException() != null) {
            throw new CommandException(command, "Error inside " + type + " stream", gobbler.getException());
        }
    }

    public int execute(Command command, long timeoutMilliseconds) {
        LOG.info("Executing command: " + command);
        return this.execute(command, new DefaultConsumer(), new DefaultConsumer(), timeoutMilliseconds);
    }

    private void closeStreams(Process process) {
        if (process != null) {
            Closeables.closeQuietly((Closeable)process.getInputStream());
            Closeables.closeQuietly((Closeable)process.getInputStream());
            Closeables.closeQuietly((Closeable)process.getOutputStream());
            Closeables.closeQuietly((Closeable)process.getErrorStream());
        }
    }

    private void waitUntilFinish(StreamGobbler thread) {
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                LOG.error("InterruptedException while waiting finish of " + thread.toString(), (Throwable)e);
            }
        }
    }

    private static class DefaultConsumer
    implements StreamConsumer {
        private DefaultConsumer() {
        }

        @Override
        public void consumeLine(String line) {
            LOG.info(line);
        }
    }

    private static class StreamGobbler
    extends Thread {
        private final InputStream is;
        private final StreamConsumer consumer;
        private volatile Exception exception;

        StreamGobbler(InputStream is, StreamConsumer consumer) {
            super("ProcessStreamGobbler");
            this.is = is;
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    this.consumeLine(line);
                }
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
            finally {
                Closeables.closeQuietly((Closeable)br);
                Closeables.closeQuietly((Closeable)isr);
            }
        }

        private void consumeLine(String line) {
            if (this.exception == null) {
                try {
                    this.consumer.consumeLine(line);
                }
                catch (Exception e) {
                    this.exception = e;
                }
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

