/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.issue.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.wsclient.issue.Issue;
import org.sonar.wsclient.issue.IssueComment;
import org.sonar.wsclient.issue.internal.DefaultIssueComment;
import org.sonar.wsclient.unmarshallers.JsonUtils;

public class DefaultIssue
implements Issue {
    private final Map json;

    DefaultIssue(Map json) {
        this.json = json;
    }

    @Override
    public String key() {
        return JsonUtils.getString(this.json, "key");
    }

    @Override
    public String componentKey() {
        return JsonUtils.getString(this.json, "component");
    }

    @Override
    public String projectKey() {
        return JsonUtils.getString(this.json, "project");
    }

    @Override
    public String ruleKey() {
        return JsonUtils.getString(this.json, "rule");
    }

    @Override
    public String severity() {
        return JsonUtils.getString(this.json, "severity");
    }

    @Override
    @CheckForNull
    public String message() {
        return JsonUtils.getString(this.json, "message");
    }

    @Override
    @CheckForNull
    public Integer line() {
        return JsonUtils.getInteger(this.json, "line");
    }

    @Override
    @CheckForNull
    public Double effortToFix() {
        return JsonUtils.getDouble(this.json, "effortToFix");
    }

    @Override
    public String status() {
        return JsonUtils.getString(this.json, "status");
    }

    @Override
    @CheckForNull
    public String resolution() {
        return JsonUtils.getString(this.json, "resolution");
    }

    @Override
    @CheckForNull
    public String reporter() {
        return JsonUtils.getString(this.json, "reporter");
    }

    @Override
    @CheckForNull
    public String assignee() {
        return JsonUtils.getString(this.json, "assignee");
    }

    @Override
    @CheckForNull
    public String author() {
        return JsonUtils.getString(this.json, "author");
    }

    @Override
    @CheckForNull
    public String actionPlan() {
        return JsonUtils.getString(this.json, "actionPlan");
    }

    @Override
    public Date creationDate() {
        return JsonUtils.getDateTime(this.json, "creationDate");
    }

    @Override
    public Date updateDate() {
        return JsonUtils.getDateTime(this.json, "updateDate");
    }

    @Override
    @CheckForNull
    public Date closeDate() {
        return JsonUtils.getDateTime(this.json, "closeDate");
    }

    @Override
    @CheckForNull
    public String attribute(String key) {
        return this.attributes().get(key);
    }

    @Override
    public Map<String, String> attributes() {
        Map attr = (Map)this.json.get("attr");
        if (attr == null) {
            return Collections.emptyMap();
        }
        return attr;
    }

    @Override
    public List<IssueComment> comments() {
        ArrayList<IssueComment> comments = new ArrayList<IssueComment>();
        List jsonComments = (List)this.json.get("comments");
        if (jsonComments != null) {
            for (Map jsonComment : jsonComments) {
                comments.add(new DefaultIssueComment(jsonComment));
            }
        }
        return comments;
    }
}

