/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.issue.internal;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.wsclient.internal.EncodingUtils;
import org.sonar.wsclient.internal.HttpRequestFactory;
import org.sonar.wsclient.issue.BulkChange;
import org.sonar.wsclient.issue.BulkChangeQuery;
import org.sonar.wsclient.issue.Issue;
import org.sonar.wsclient.issue.IssueClient;
import org.sonar.wsclient.issue.IssueComment;
import org.sonar.wsclient.issue.IssueQuery;
import org.sonar.wsclient.issue.Issues;
import org.sonar.wsclient.issue.NewIssue;
import org.sonar.wsclient.issue.internal.DefaultIssue;
import org.sonar.wsclient.issue.internal.DefaultIssueComment;
import org.sonar.wsclient.issue.internal.IssueJsonParser;
import org.sonar.wsclient.jsonsimple.JSONValue;

public class DefaultIssueClient
implements IssueClient {
    private static final String SEARCH_URL = "/api/issues/search";
    private final HttpRequestFactory requestFactory;
    private final IssueJsonParser parser;

    public DefaultIssueClient(HttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
        this.parser = new IssueJsonParser();
    }

    @Override
    public Issues find(IssueQuery query) {
        String json = this.requestFactory.get(SEARCH_URL, query.urlParams());
        return this.parser.parseIssues(json);
    }

    @Override
    public Issue create(NewIssue newIssue) {
        String json = this.requestFactory.post("/api/issues/create", newIssue.urlParams());
        return this.jsonToIssue(json);
    }

    @Override
    public Issue setSeverity(String issueKey, String severity) {
        Map<String, Object> params = EncodingUtils.toMap("issue", issueKey, "severity", severity);
        String json = this.requestFactory.post("/api/issues/set_severity", params);
        return this.jsonToIssue(json);
    }

    @Override
    public Issue assign(String issueKey, @Nullable String assignee) {
        Map<String, Object> params = EncodingUtils.toMap("issue", issueKey, "assignee", assignee);
        String json = this.requestFactory.post("/api/issues/assign", params);
        return this.jsonToIssue(json);
    }

    @Override
    public Issue plan(String issueKey, @Nullable String actionPlanKey) {
        Map<String, Object> params = EncodingUtils.toMap("issue", issueKey, "plan", actionPlanKey);
        String json = this.requestFactory.post("/api/issues/plan", params);
        return this.jsonToIssue(json);
    }

    @Override
    public IssueComment addComment(String issueKey, String markdownText) {
        Map<String, Object> params = EncodingUtils.toMap("issue", issueKey, "text", markdownText);
        String json = this.requestFactory.post("/api/issues/add_comment", params);
        Map rootJson = (Map)JSONValue.parse(json);
        return new DefaultIssueComment((Map)rootJson.get("comment"));
    }

    @Override
    public List<String> transitions(String issueKey) {
        Map<String, Object> queryParams = EncodingUtils.toMap("issue", issueKey);
        String json = this.requestFactory.get("/api/issues/transitions", queryParams);
        return this.parser.parseTransitions(json);
    }

    @Override
    public Issue doTransition(String issueKey, String transition) {
        Map<String, Object> params = EncodingUtils.toMap("issue", issueKey, "transition", transition);
        String json = this.requestFactory.post("/api/issues/do_transition", params);
        return this.jsonToIssue(json);
    }

    @Override
    public List<String> actions(String issueKey) {
        Map<String, Object> queryParams = EncodingUtils.toMap("issue", issueKey);
        String json = this.requestFactory.get("/api/issues/actions", queryParams);
        return this.parser.parseActions(json);
    }

    @Override
    public Issue doAction(String issueKey, String action) {
        Map<String, Object> params = EncodingUtils.toMap("issue", issueKey, "actionKey", action);
        String json = this.requestFactory.post("/api/issues/do_action", params);
        return this.jsonToIssue(json);
    }

    @Override
    public BulkChange bulkChange(BulkChangeQuery query) {
        String json = this.requestFactory.post("/api/issues/bulk_change", query.urlParams());
        return this.parser.parseBulkChange(json);
    }

    private Issue jsonToIssue(String json) {
        Map jsonRoot = (Map)JSONValue.parse(json);
        return new DefaultIssue((Map)jsonRoot.get("issue"));
    }
}

