/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.issue.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sonar.wsclient.base.Paging;
import org.sonar.wsclient.component.Component;
import org.sonar.wsclient.issue.BulkChange;
import org.sonar.wsclient.issue.Issues;
import org.sonar.wsclient.issue.internal.DefaultActionPlan;
import org.sonar.wsclient.issue.internal.DefaultBulkChange;
import org.sonar.wsclient.issue.internal.DefaultIssue;
import org.sonar.wsclient.issue.internal.DefaultIssues;
import org.sonar.wsclient.jsonsimple.JSONArray;
import org.sonar.wsclient.jsonsimple.JSONValue;
import org.sonar.wsclient.rule.Rule;
import org.sonar.wsclient.unmarshallers.JsonUtils;
import org.sonar.wsclient.user.User;

public class IssueJsonParser {
    public Issues parseIssues(String json) {
        DefaultIssues result = new DefaultIssues();
        Map jsonRoot = (Map)JSONValue.parse(json);
        List jsonIssues = (List)jsonRoot.get("issues");
        if (jsonIssues != null) {
            for (Map jsonIssue : jsonIssues) {
                result.add(new DefaultIssue(jsonIssue));
            }
        }
        this.parseRules(result, jsonRoot);
        this.parseUsers(result, jsonRoot);
        this.parseComponents(result, jsonRoot);
        this.parseProjects(result, jsonRoot);
        this.parseActionPlans(result, jsonRoot);
        this.parsePaging(result, jsonRoot);
        return result;
    }

    private void parsePaging(DefaultIssues result, Map jsonRoot) {
        Map paging = (Map)jsonRoot.get("paging");
        result.setPaging(new Paging(paging));
        result.setMaxResultsReached(JsonUtils.getBoolean(jsonRoot, "maxResultsReached"));
    }

    private void parseProjects(DefaultIssues result, Map jsonRoot) {
        List jsonProjects = (List)jsonRoot.get("projects");
        if (jsonProjects != null) {
            for (Map jsonProject : jsonProjects) {
                result.addProject(new Component(jsonProject));
            }
        }
    }

    private void parseComponents(DefaultIssues result, Map jsonRoot) {
        List jsonComponents = (List)jsonRoot.get("components");
        if (jsonComponents != null) {
            for (Map jsonComponent : jsonComponents) {
                result.addComponent(new Component(jsonComponent));
            }
        }
    }

    private void parseUsers(DefaultIssues result, Map jsonRoot) {
        List jsonUsers = (List)jsonRoot.get("users");
        if (jsonUsers != null) {
            for (Map jsonUser : jsonUsers) {
                result.add(new User(jsonUser));
            }
        }
    }

    private void parseRules(DefaultIssues result, Map jsonRoot) {
        List jsonRules = (List)jsonRoot.get("rules");
        if (jsonRules != null) {
            for (Map jsonRule : jsonRules) {
                result.add(new Rule(jsonRule));
            }
        }
    }

    private void parseActionPlans(DefaultIssues result, Map jsonRoot) {
        List jsonRules = (List)jsonRoot.get("actionPlans");
        if (jsonRules != null) {
            for (Map jsonRule : jsonRules) {
                result.add(new DefaultActionPlan(jsonRule));
            }
        }
    }

    List<String> parseTransitions(String json) {
        ArrayList<String> transitions = new ArrayList<String>();
        Map jRoot = (Map)JSONValue.parse(json);
        List jTransitions = (List)jRoot.get("transitions");
        for (String jTransition : jTransitions) {
            transitions.add(jTransition);
        }
        return transitions;
    }

    List<String> parseActions(String json) {
        ArrayList<String> actions = new ArrayList<String>();
        Map jRoot = (Map)JSONValue.parse(json);
        List jActions = (List)jRoot.get("actions");
        for (String jAction : jActions) {
            actions.add(jAction);
        }
        return actions;
    }

    BulkChange parseBulkChange(String json) {
        DefaultBulkChange result = new DefaultBulkChange();
        Map jsonRoot = (Map)JSONValue.parse(json);
        Map issuesChanged = (Map)jsonRoot.get("issuesChanged");
        result.setTotalIssuesChanged(JsonUtils.getInteger(issuesChanged, "total"));
        Map issuesNotChanged = (Map)jsonRoot.get("issuesNotChanged");
        result.setTotalIssuesNotChanged(JsonUtils.getInteger(issuesNotChanged, "total"));
        JSONArray issuesJson = JsonUtils.getArray(issuesNotChanged, "issues");
        if (issuesJson != null) {
            result.setIssuesNotChanged(issuesJson);
        }
        return result;
    }
}

