/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Model;

public class Resource
extends Model {
    public static final String SCOPE_SET = "PRJ";
    public static final String SCOPE_SPACE = "DIR";
    public static final String SCOPE_ENTITY = "FIL";
    public static final String QUALIFIER_VIEW = "VW";
    public static final String QUALIFIER_SUBVIEW = "SVW";
    public static final String QUALIFIER_LIB = "LIB";
    public static final String QUALIFIER_PROJECT = "TRK";
    public static final String QUALIFIER_MODULE = "BRC";
    public static final String QUALIFIER_PACKAGE = "PAC";
    public static final String QUALIFIER_DIRECTORY = "DIR";
    public static final String QUALIFIER_FILE = "FIL";
    public static final String QUALIFIER_CLASS = "CLA";
    public static final String QUALIFIER_UNIT_TEST_CLASS = "UTS";
    public static final String LANGUAGE_JAVA = "java";
    private Integer id;
    private String key;
    private String name;
    private String longName;
    private String scope;
    private String qualifier;
    private String language;
    private String version;
    private Integer copy;
    private String description;
    private Date date;
    private List<Measure> measures;
    private Date creationDate;
    private String period1Mode;
    private String period2Mode;
    private String period3Mode;
    private String period4Mode;
    private String period5Mode;
    private String period1Param;
    private String period2Param;
    private String period3Param;
    private String period4Param;
    private String period5Param;
    private Date period1Date;
    private Date period2Date;
    private Date period3Date;
    private Date period4Date;
    private Date period5Date;

    @CheckForNull
    public Integer getId() {
        return this.id;
    }

    public Resource setId(@Nullable Integer id) {
        this.id = id;
        return this;
    }

    @CheckForNull
    public String getKey() {
        return this.key;
    }

    public Resource setKey(@Nullable String key) {
        this.key = key;
        return this;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public Resource setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @CheckForNull
    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getName(boolean longFormatIfDefined) {
        if (longFormatIfDefined && this.longName != null && !"".equals(this.longName)) {
            return this.longName;
        }
        return this.name;
    }

    @CheckForNull
    public String getLongName() {
        return this.longName;
    }

    public Resource setLongName(@Nullable String longName) {
        this.longName = longName;
        return this;
    }

    public Resource setName(@Nullable String s) {
        this.name = s;
        return this;
    }

    @CheckForNull
    public String getScope() {
        return this.scope;
    }

    public Resource setScope(@Nullable String scope) {
        this.scope = scope;
        return this;
    }

    @CheckForNull
    public String getQualifier() {
        return this.qualifier;
    }

    public Resource setQualifier(@Nullable String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    @CheckForNull
    public String getLanguage() {
        return this.language;
    }

    public Resource setLanguage(@Nullable String language) {
        this.language = language;
        return this;
    }

    @CheckForNull
    public String getVersion() {
        return this.version;
    }

    public Resource setVersion(@Nullable String version) {
        this.version = version;
        return this;
    }

    @CheckForNull
    public Integer getCopy() {
        return this.copy;
    }

    public Resource setCopy(@Nullable Integer copy) {
        this.copy = copy;
        return this;
    }

    @CheckForNull
    public Date getDate() {
        return this.date;
    }

    public Resource setDate(@Nullable Date d) {
        this.date = d;
        return this;
    }

    @CheckForNull
    public Date getCreationDate() {
        return this.creationDate;
    }

    public Resource setCreationDate(@Nullable Date d) {
        this.creationDate = d;
        return this;
    }

    public List<Measure> getMeasures() {
        if (this.measures == null) {
            return Collections.emptyList();
        }
        return this.measures;
    }

    public Measure getMeasure(String metricKey) {
        for (Measure measure : this.getMeasures()) {
            if (!metricKey.equals(measure.getMetricKey())) continue;
            return measure;
        }
        return null;
    }

    public Double getMeasureValue(String metricKey) {
        Measure measure = this.getMeasure(metricKey);
        if (measure != null) {
            return measure.getValue();
        }
        return null;
    }

    public Integer getMeasureIntValue(String metricKey) {
        Double d = this.getMeasureValue(metricKey);
        if (d != null) {
            return d.intValue();
        }
        return null;
    }

    public String getMeasureFormattedValue(String metricKey, String defaultValue) {
        Measure measure = this.getMeasure(metricKey);
        if (measure != null) {
            return measure.getFormattedValue(defaultValue);
        }
        return defaultValue;
    }

    public void setMeasures(List<Measure> measures) {
        this.measures = measures;
    }

    @CheckForNull
    public String getPeriod1Mode() {
        return this.period1Mode;
    }

    public Resource setPeriod1Mode(@Nullable String period1Mode) {
        this.period1Mode = period1Mode;
        return this;
    }

    @CheckForNull
    public String getPeriod2Mode() {
        return this.period2Mode;
    }

    public Resource setPeriod2Mode(@Nullable String period2Mode) {
        this.period2Mode = period2Mode;
        return this;
    }

    @CheckForNull
    public String getPeriod3Mode() {
        return this.period3Mode;
    }

    public Resource setPeriod3Mode(@Nullable String period3Mode) {
        this.period3Mode = period3Mode;
        return this;
    }

    @CheckForNull
    public String getPeriod4Mode() {
        return this.period4Mode;
    }

    public Resource setPeriod4Mode(@Nullable String period4Mode) {
        this.period4Mode = period4Mode;
        return this;
    }

    @CheckForNull
    public String getPeriod5Mode() {
        return this.period5Mode;
    }

    public Resource setPeriod5Mode(@Nullable String period5Mode) {
        this.period5Mode = period5Mode;
        return this;
    }

    @CheckForNull
    public String getPeriod1Param() {
        return this.period1Param;
    }

    public Resource setPeriod1Param(@Nullable String period1Param) {
        this.period1Param = period1Param;
        return this;
    }

    @CheckForNull
    public String getPeriod2Param() {
        return this.period2Param;
    }

    public Resource setPeriod2Param(@Nullable String period2Param) {
        this.period2Param = period2Param;
        return this;
    }

    @CheckForNull
    public String getPeriod3Param() {
        return this.period3Param;
    }

    public Resource setPeriod3Param(@Nullable String period3Param) {
        this.period3Param = period3Param;
        return this;
    }

    @CheckForNull
    public String getPeriod4Param() {
        return this.period4Param;
    }

    public Resource setPeriod4Param(@Nullable String period4Param) {
        this.period4Param = period4Param;
        return this;
    }

    @CheckForNull
    public String getPeriod5Param() {
        return this.period5Param;
    }

    public Resource setPeriod5Param(@Nullable String period5Param) {
        this.period5Param = period5Param;
        return this;
    }

    @CheckForNull
    public Date getPeriod1Date() {
        return this.period1Date;
    }

    public Resource setPeriod1Date(@Nullable Date period1Date) {
        this.period1Date = period1Date;
        return this;
    }

    @CheckForNull
    public Date getPeriod2Date() {
        return this.period2Date;
    }

    public Resource setPeriod2Date(@Nullable Date period2Date) {
        this.period2Date = period2Date;
        return this;
    }

    @CheckForNull
    public Date getPeriod3Date() {
        return this.period3Date;
    }

    public Resource setPeriod3Date(@Nullable Date period3Date) {
        this.period3Date = period3Date;
        return this;
    }

    @CheckForNull
    public Date getPeriod4Date() {
        return this.period4Date;
    }

    public Resource setPeriod4Date(@Nullable Date period4Date) {
        this.period4Date = period4Date;
        return this;
    }

    @CheckForNull
    public Date getPeriod5Date() {
        return this.period5Date;
    }

    public Resource setPeriod5Date(@Nullable Date period5Date) {
        this.period5Date = period5Date;
        return this;
    }

    public String toString() {
        return "[id=" + this.id + ",key=" + this.key + "]";
    }
}

