/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.CreateQuery;
import org.sonar.wsclient.services.Metric;

public class MetricCreateQuery
extends CreateQuery<Metric> {
    private String key;
    private String name;
    private String description;
    private String domain;
    private String type;

    public static MetricCreateQuery create(String metricKey) {
        return new MetricCreateQuery(metricKey);
    }

    private MetricCreateQuery(String key) {
        this.key = key;
    }

    public MetricCreateQuery setName(String name) {
        this.name = name;
        return this;
    }

    public MetricCreateQuery setDescription(String description) {
        this.description = description;
        return this;
    }

    public MetricCreateQuery setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public MetricCreateQuery setType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder();
        url.append("/api/metrics");
        url.append("/").append(MetricCreateQuery.encode(this.key));
        url.append('?');
        MetricCreateQuery.appendUrlParameter(url, "name", this.name);
        MetricCreateQuery.appendUrlParameter(url, "description", this.description);
        MetricCreateQuery.appendUrlParameter(url, "domain", this.domain);
        MetricCreateQuery.appendUrlParameter(url, "val_type", this.type);
        return url.toString();
    }

    @Override
    public Class<Metric> getModelClass() {
        return Metric.class;
    }
}

