/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.unmarshallers;

import java.util.HashMap;
import java.util.Map;
import org.sonar.wsclient.services.Authentication;
import org.sonar.wsclient.services.Dependency;
import org.sonar.wsclient.services.DependencyTree;
import org.sonar.wsclient.services.Event;
import org.sonar.wsclient.services.Favourite;
import org.sonar.wsclient.services.ManualMeasure;
import org.sonar.wsclient.services.Metric;
import org.sonar.wsclient.services.Model;
import org.sonar.wsclient.services.Plugin;
import org.sonar.wsclient.services.Profile;
import org.sonar.wsclient.services.Property;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceSearchResult;
import org.sonar.wsclient.services.Server;
import org.sonar.wsclient.services.ServerSetup;
import org.sonar.wsclient.services.Source;
import org.sonar.wsclient.services.TimeMachine;
import org.sonar.wsclient.unmarshallers.AuthenticationUnmarshaller;
import org.sonar.wsclient.unmarshallers.DependencyTreeUnmarshaller;
import org.sonar.wsclient.unmarshallers.DependencyUnmarshaller;
import org.sonar.wsclient.unmarshallers.EventUnmarshaller;
import org.sonar.wsclient.unmarshallers.FavouriteUnmarshaller;
import org.sonar.wsclient.unmarshallers.ManualMeasureUnmarshaller;
import org.sonar.wsclient.unmarshallers.MetricUnmarshaller;
import org.sonar.wsclient.unmarshallers.PluginUnmarshaller;
import org.sonar.wsclient.unmarshallers.ProfileUnmarshaller;
import org.sonar.wsclient.unmarshallers.PropertyUnmarshaller;
import org.sonar.wsclient.unmarshallers.ResourceSearchUnmarshaller;
import org.sonar.wsclient.unmarshallers.ResourceUnmarshaller;
import org.sonar.wsclient.unmarshallers.ServerSetupUnmarshaller;
import org.sonar.wsclient.unmarshallers.ServerUnmarshaller;
import org.sonar.wsclient.unmarshallers.SourceUnmarshaller;
import org.sonar.wsclient.unmarshallers.TimeMachineUnmarshaller;
import org.sonar.wsclient.unmarshallers.Unmarshaller;

public final class Unmarshallers {
    private static Map<Class, Unmarshaller> unmarshallers = new HashMap<Class, Unmarshaller>();

    private Unmarshallers() {
    }

    public static <M extends Model> Unmarshaller<M> forModel(Class<M> modelClass) {
        return unmarshallers.get(modelClass);
    }

    static {
        unmarshallers.put(Metric.class, new MetricUnmarshaller());
        unmarshallers.put(Dependency.class, new DependencyUnmarshaller());
        unmarshallers.put(Resource.class, new ResourceUnmarshaller());
        unmarshallers.put(Property.class, new PropertyUnmarshaller());
        unmarshallers.put(Source.class, new SourceUnmarshaller());
        unmarshallers.put(Server.class, new ServerUnmarshaller());
        unmarshallers.put(ServerSetup.class, new ServerSetupUnmarshaller());
        unmarshallers.put(DependencyTree.class, new DependencyTreeUnmarshaller());
        unmarshallers.put(Event.class, new EventUnmarshaller());
        unmarshallers.put(Favourite.class, new FavouriteUnmarshaller());
        unmarshallers.put(Plugin.class, new PluginUnmarshaller());
        unmarshallers.put(TimeMachine.class, new TimeMachineUnmarshaller());
        unmarshallers.put(Profile.class, new ProfileUnmarshaller());
        unmarshallers.put(ManualMeasure.class, new ManualMeasureUnmarshaller());
        unmarshallers.put(Authentication.class, new AuthenticationUnmarshaller());
        unmarshallers.put(ResourceSearchResult.class, new ResourceSearchUnmarshaller());
    }
}

