/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.collection;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.basic.ArrayType;
import org.codehaus.xfire.fault.XFireFault;

public class CollectionType
extends ArrayType {
    private Class componentType;

    public CollectionType(Class componentType) {
        this.componentType = componentType;
    }

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        try {
            Type compType = this.getComponentType();
            Collection values = this.createCollection();
            while (reader.hasMoreElementReaders()) {
                MessageReader childReader = reader.getNextElementReader();
                values.add(compType.readObject(childReader, context));
            }
            return values;
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    protected Collection createCollection() {
        AbstractCollection values = null;
        values = this.getTypeClass().isAssignableFrom(List.class) ? new ArrayList() : (this.getTypeClass().isAssignableFrom(Set.class) ? new HashSet() : new ArrayList());
        return values;
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        if (object == null) {
            return;
        }
        try {
            Collection list = (Collection)object;
            Type type = this.getComponentType();
            if (type == null) {
                throw new XFireRuntimeException("Couldn't find type for " + type.getTypeClass() + ".");
            }
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                String ns = null;
                ns = type.isAbstract() ? this.getSchemaType().getNamespaceURI() : type.getSchemaType().getNamespaceURI();
                MessageWriter cwriter = writer.getElementWriter(type.getSchemaType().getLocalPart(), ns);
                type.writeObject(itr.next(), writer, context);
                cwriter.close();
            }
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    public Type getComponentType() {
        Type type = this.getTypeMapping().getType(this.componentType);
        if (type == null) {
            type = this.getTypeMapping().getTypeCreator().createType(this.componentType);
            this.getTypeMapping().register(type);
        }
        return type;
    }
}

