/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.castor;

import java.io.IOException;
import java.io.PrintWriter;
import javanet.staxutils.ContentHandlerToXMLStreamWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.stax.ElementReader;
import org.codehaus.xfire.aegis.stax.ElementWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.dom4j.DocumentFactory;
import org.dom4j.Node;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.io.STAXEventReader;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class CastorType
extends Type {
    private static final Log log = LogFactory.getLog((Class)CastorType.class);
    private Mapping mapping;

    public CastorType(Class clazz, Mapping mapping) {
        this.mapping = mapping;
        this.setTypeClass(clazz);
        this.initType();
    }

    public QName getSchemaType() {
        return super.getSchemaType();
    }

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        Unmarshaller unmarshaller;
        XMLStreamReader sReader = ((ElementReader)reader).getXMLStreamReader();
        Node node = null;
        try {
            XMLEventReader xer = XMLInputFactory.newInstance().createXMLEventReader(sReader);
            node = new STAXEventReader((DocumentFactory)new DOMDocumentFactory()).readNode(xer);
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error creating a dom4j Document from a StAX XMLEventReader.", (Throwable)e);
            throw new XFireFault(e);
        }
        try {
            unmarshaller = new Unmarshaller(this.getTypeClass());
            if (this.mapping != null) {
                unmarshaller.setMapping(this.mapping);
            }
            if (log.isDebugEnabled()) {
                unmarshaller.setDebug(true);
                unmarshaller.setLogWriter((PrintWriter)new LogPrintWriter());
            }
        }
        catch (MappingException e) {
            String error = "Could not use specified mapping for unmarshalling.";
            log.error((Object)error, (Throwable)e);
            throw new XFireRuntimeException(error, e);
        }
        try {
            return unmarshaller.unmarshal((org.w3c.dom.Node)node);
        }
        catch (MarshalException e) {
            log.error((Object)"Error during unmarshalling process.", (Throwable)e);
            throw new XFireFault(e);
        }
        catch (ValidationException e) {
            log.error((Object)"Error validating DOM node for unmarshalling.", (Throwable)e);
            throw new XFireFault(e);
        }
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        Marshaller marshaller;
        XMLStreamWriter sWriter = ((ElementWriter)writer).getXMLStreamWriter();
        MessagePartInfo part = (MessagePartInfo)context.getProperty("currentMessagePart");
        try {
            marshaller = new Marshaller((ContentHandler)new SafeContentHandler((ContentHandler)new ContentHandlerToXMLStreamWriter(sWriter)));
            marshaller.setRootElement(part.getName().getLocalPart());
            if (this.mapping != null) {
                marshaller.setMapping(this.mapping);
            }
        }
        catch (IOException e) {
            log.error((Object)"Could not marshall type.", (Throwable)e);
            throw new XFireFault(e);
        }
        catch (MappingException e) {
            log.error((Object)"Could not use specified Castor mapping for marshalling.", (Throwable)e);
            throw new XFireFault(e);
        }
        try {
            marshaller.marshal(object);
        }
        catch (MarshalException e) {
            log.error((Object)"Error during marshalling process.", (Throwable)e);
            throw new XFireFault(e);
        }
        catch (ValidationException e) {
            log.error((Object)"Could not marshall object due to validation error.", (Throwable)e);
            throw new XFireFault(e);
        }
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isComplex() {
        return true;
    }

    public boolean isWriteOuter() {
        return false;
    }

    public void initType() {
        Class clazz = this.getTypeClass();
        Class xdClass = null;
        XMLClassDescriptor xd = null;
        if (this.mapping != null) {
            try {
                xd = (XMLClassDescriptor)this.mapping.getResolver(Mapping.XML).getDescriptor(clazz);
                String nsUri = xd.getNameSpaceURI() == null ? "" : xd.getNameSpaceURI();
                String localTypeName = Introspector.introspected((XMLClassDescriptor)xd) ? this.getTypeClass().getSimpleName() : xd.getXMLName();
                String nsPrefix = xd.getNameSpacePrefix() == null ? "" : xd.getNameSpacePrefix();
                this.setSchemaType(new QName(nsUri, localTypeName, nsPrefix));
            }
            catch (MappingException e) {
                String error = "Error getting resolver from mapping.";
                log.error((Object)error, (Throwable)e);
                throw new XFireRuntimeException(error, e);
            }
        }
        try {
            xdClass = ClassLoaderUtils.loadClass(clazz.getName() + "Descriptor", this.getClass());
            if (xdClass != null && xdClass.newInstance() instanceof XMLClassDescriptor) {
                xd = (XMLClassDescriptor)xdClass.newInstance();
                String nsUri = xd.getNameSpaceURI() == null ? "" : xd.getNameSpaceURI();
                String nsPrefix = xd.getNameSpacePrefix() == null ? "" : xd.getNameSpacePrefix();
                String localTypeName = xd.getXMLName();
                this.setSchemaType(new QName(nsUri, localTypeName, nsPrefix));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private class SafeContentHandler
    implements ContentHandler {
        private ContentHandler handler;

        public SafeContentHandler(ContentHandler handler) {
            this.handler = handler;
        }

        public void setDocumentLocator(Locator arg0) {
            this.handler.setDocumentLocator(arg0);
        }

        public void startDocument() throws SAXException {
            log.debug((Object)"Ignoring startDocument() call to ContentHandler.");
        }

        public void endDocument() throws SAXException {
            log.debug((Object)"Ignoring endDocument() call to ContentHandler.");
        }

        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
            this.handler.startPrefixMapping(arg0, arg1);
        }

        public void endPrefixMapping(String arg0) throws SAXException {
            this.handler.endPrefixMapping(arg0);
        }

        public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
            this.handler.startElement(arg0, arg1, arg2, arg3);
        }

        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            this.handler.endElement(arg0, arg1, arg2);
        }

        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            this.handler.characters(arg0, arg1, arg2);
        }

        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
            this.handler.ignorableWhitespace(arg0, arg1, arg2);
        }

        public void processingInstruction(String arg0, String arg1) throws SAXException {
            this.handler.processingInstruction(arg0, arg1);
        }

        public void skippedEntity(String arg0) throws SAXException {
            this.handler.skippedEntity(arg0);
        }
    }

    private class LogPrintWriter
    extends PrintWriter {
        public LogPrintWriter() {
            super(System.err);
        }

        public void println(String string) {
            log.debug((Object)string);
        }
    }
}

