/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.fault.FaultInfoException;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.util.stax.ElementStreamWriter;

public class CustomFaultHandler
extends AbstractHandler {
    public CustomFaultHandler() {
        this.setPhase("user");
    }

    public void invoke(MessageContext context) throws Exception {
        XFireFault fault = (XFireFault)context.getExchange().getFaultMessage().getBody();
        Throwable cause = fault.getCause();
        OperationInfo op = null;
        if (context.getExchange() != null) {
            op = context.getExchange().getOperation();
        }
        if (cause == null || op == null) {
            return;
        }
        FaultInfo faultPart = this.getFaultForClass(op, cause.getClass());
        if (faultPart != null) {
            this.handleFault(context, fault, cause, (MessagePartInfo)faultPart.getMessageParts().get(0));
        }
    }

    protected void handleFault(MessageContext context, XFireFault fault, Throwable cause, MessagePartInfo faultPart) throws XFireFault {
        ElementStreamWriter writer = new ElementStreamWriter(fault.getDetail());
        Object faultBean = this.getFaultBean(cause, faultPart, context);
        try {
            AbstractBinding.writeParameter(writer, context, faultBean, faultPart, faultPart.getName().getNamespaceURI());
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Could not write to outgoing stream.", e, XFireFault.RECEIVER);
        }
    }

    protected Object getFaultBean(Throwable cause, MessagePartInfo faultPart, MessageContext context) {
        if (FaultInfoException.class.isAssignableFrom(cause.getClass())) {
            try {
                Method method = cause.getClass().getMethod("getFaultInfo", new Class[0]);
                return method.invoke((Object)cause, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new XFireRuntimeException("Couldn't invoke getFaultInfo method.", e);
            }
            catch (NoSuchMethodException e) {
                throw new XFireRuntimeException("Custom faults need a getFaultInfo method.", e);
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Couldn't access getFaultInfo method.", e);
            }
        }
        return cause;
    }

    public FaultInfo getFaultForClass(OperationInfo op, Class class1) {
        Iterator itr = op.getFaults().iterator();
        while (itr.hasNext()) {
            FaultInfo faultInfo = (FaultInfo)itr.next();
            if (!class1.isAssignableFrom(faultInfo.getExceptionClass())) continue;
            return faultInfo;
        }
        return null;
    }
}

