/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.util.Iterator;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessagePartContainer;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.BindingProvider;

public abstract class AbstractBindingProvider
implements BindingProvider {
    protected static final int IN_PARAM = 0;
    protected static final int OUT_PARAM = 1;
    protected static final int FAULT_PARAM = 2;

    public void initialize(Service endpoint) {
        Iterator itr = endpoint.getServiceInfo().getOperations().iterator();
        while (itr.hasNext()) {
            OperationInfo opInfo = (OperationInfo)itr.next();
            try {
                this.initializeMessage(endpoint, opInfo.getInputMessage(), 0);
            }
            catch (XFireRuntimeException e) {
                e.prepend("Error initializing parameters for method " + opInfo.getMethod());
                throw e;
            }
            try {
                if (opInfo.hasOutput()) {
                    this.initializeMessage(endpoint, opInfo.getOutputMessage(), 1);
                }
            }
            catch (XFireRuntimeException e) {
                e.prepend("Error initializing return value for method " + opInfo.getMethod());
                throw e;
            }
            try {
                Iterator faultItr = opInfo.getFaults().iterator();
                while (faultItr.hasNext()) {
                    FaultInfo info = (FaultInfo)faultItr.next();
                    this.initializeMessage(endpoint, info, 2);
                }
            }
            catch (XFireRuntimeException e) {
                e.prepend("Error initializing fault for method " + opInfo.getMethod());
                throw e;
            }
            try {
                Iterator bItr = endpoint.getBindings().iterator();
                while (bItr.hasNext()) {
                    Binding binding = (Binding)bItr.next();
                    this.initializeMessage(endpoint, binding.getHeaders(opInfo.getInputMessage()), 0);
                    if (!opInfo.hasOutput()) continue;
                    this.initializeMessage(endpoint, binding.getHeaders(opInfo.getOutputMessage()), 1);
                }
            }
            catch (XFireRuntimeException e) {
                e.prepend("Error initializing headers for method " + opInfo.getMethod());
                throw e;
            }
        }
    }

    protected void initializeMessage(Service service, MessagePartContainer container, int type) {
    }
}

