/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartContainer;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.Invoker;
import org.codehaus.xfire.util.stax.ElementStreamWriter;
import org.codehaus.xfire.util.stax.JDOMStreamReader;
import org.jdom.Element;
import org.jdom.Namespace;

public class ServiceInvocationHandler
extends AbstractHandler {
    private static final Log logger = LogFactory.getLog((String)AbstractBinding.class.getName());

    public ServiceInvocationHandler() {
        this.setPhase("service");
    }

    public void invoke(final MessageContext context) throws Exception {
        try {
            List params = (List)context.getInMessage().getBody();
            final OperationInfo operation = context.getExchange().getOperation();
            Binding binding = context.getBinding();
            MessageInfo msg = AbstractBinding.getIncomingMessageInfo(context);
            MessageInfo outMsg = AbstractBinding.getOutgoingMessageInfo(context);
            MessagePartContainer headerMsg = binding.getHeaders(msg);
            MessagePartContainer outHeaderMsg = null;
            if (outMsg != null) {
                outHeaderMsg = binding.getHeaders(outMsg);
            }
            final Object[] paramArray = this.fillInHolders(context, operation, msg, outMsg, headerMsg, outHeaderMsg, params);
            context.getInMessage().setBody(paramArray);
            ServiceInvocationHandler.readHeaders(context, headerMsg, paramArray);
            final Invoker invoker = context.getService().getInvoker();
            if (!operation.isAsync()) {
                this.sendMessage(context, paramArray, operation, invoker);
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            ServiceInvocationHandler.this.sendMessage(context, paramArray, operation, invoker);
                        }
                        catch (Exception e) {
                            XFireFault fault = XFireFault.createFault(e);
                            context.getInPipeline().handleFault(fault, context);
                        }
                    }
                };
                Thread opthread = new Thread(runnable);
                opthread.start();
            }
        }
        catch (XFireRuntimeException e) {
            logger.warn((Object)"Error invoking service.", (Throwable)e);
            throw new XFireFault("Error invoking service" + (e.getMessage() != null ? ": " + e.getMessage() : "."), e, XFireFault.SENDER);
        }
    }

    public static void readHeaders(MessageContext context, MessagePartContainer headerMsg, Object[] paramArray) throws XFireFault {
        List headerInfos = headerMsg.getMessageParts();
        Iterator itr = headerInfos.iterator();
        while (itr.hasNext()) {
            MessagePartInfo header = (MessagePartInfo)itr.next();
            BindingProvider provider = context.getService().getBindingProvider();
            XMLStreamReader headerReader = ServiceInvocationHandler.getXMLStreamReader(context.getInMessage(), header);
            if (headerReader == null) continue;
            Object headerVal = provider.readParameter(header, headerReader, context);
            if (paramArray[header.getIndex()] != null) continue;
            paramArray[header.getIndex()] = headerVal;
        }
    }

    protected Object[] fillInHolders(MessageContext context, OperationInfo opInfo, MessageInfo inMsg, MessageInfo outMsg, MessagePartContainer headerMsg, MessagePartContainer outHeaderMsg, List params) {
        int total;
        int outSize = 0;
        if (outMsg != null) {
            outSize = outHeaderMsg.size() + (outMsg.size() == 0 ? 0 : outMsg.size() - 1);
        }
        if ((total = inMsg.size() + headerMsg.size() + outSize) == params.size()) {
            return params.toArray();
        }
        Object[] newParams = new Object[total];
        List parts = inMsg.getMessageParts();
        for (int i = 0; i < parts.size(); ++i) {
            MessagePartInfo part = (MessagePartInfo)parts.get(i);
            newParams[part.getIndex()] = params.get(i);
        }
        if (!AbstractBinding.isClientModeOn(context)) {
            this.fillInHolders(outMsg, newParams);
            this.fillInHolders(outHeaderMsg, newParams);
        }
        return newParams;
    }

    private void fillInHolders(MessagePartContainer msg, Object[] newParams) {
        Iterator itr = msg.getMessageParts().iterator();
        while (itr.hasNext()) {
            MessagePartInfo part = (MessagePartInfo)itr.next();
            if (part.getIndex() < 0) continue;
            try {
                Object holder = part.getTypeClass().newInstance();
                newParams[part.getIndex()] = holder;
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Could not instantiate holder class.", e);
            }
        }
    }

    protected void sendMessage(MessageContext context, Object[] params, OperationInfo operation, Invoker invoker) throws Exception {
        Object value = invoker.invoke(operation.getMethod(), params, context);
        if (context.getExchange().hasOutMessage()) {
            OutMessage outMsg = context.getExchange().getOutMessage();
            ServiceInvocationHandler.writeHeaders(context);
            context.setCurrentMessage(outMsg);
            outMsg.setBody(new Object[]{value});
            outMsg.setSerializer(context.getBinding().getSerializer(operation));
            context.getOutPipeline().invoke(context);
        }
    }

    public static void writeHeaders(MessageContext context) throws XFireFault, XMLStreamException {
        MessageInfo msgInfo = AbstractBinding.getOutgoingMessageInfo(context);
        MessagePartContainer headers = context.getBinding().getHeaders(msgInfo);
        if (headers.size() == 0) {
            return;
        }
        Object[] body = (Object[])context.getCurrentMessage().getBody();
        ElementStreamWriter writer = new ElementStreamWriter(context.getOutMessage().getOrCreateHeader());
        Iterator itr = headers.getMessageParts().iterator();
        while (itr.hasNext()) {
            MessagePartInfo part = (MessagePartInfo)itr.next();
            BindingProvider provider = context.getService().getBindingProvider();
            AbstractBinding.writeParameter(writer, context, body[part.getIndex()], part, part.getName().getNamespaceURI());
        }
    }

    private static XMLStreamReader getXMLStreamReader(AbstractMessage msg, MessagePartInfo header) {
        if (msg.getHeader() == null) {
            return null;
        }
        QName name = header.getName();
        Element el = msg.getHeader().getChild(name.getLocalPart(), Namespace.getNamespace((String)name.getNamespaceURI()));
        if (el == null) {
            return null;
        }
        JDOMStreamReader reader = new JDOMStreamReader(el);
        try {
            reader.next();
        }
        catch (XMLStreamException e) {
            // empty catch block
        }
        return reader;
    }
}

