/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.spring;

import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.spring.context.ClassPathXmlApplicationContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class XFireConfigLoader {
    private Log log = LogFactory.getLog((Class)XFireConfigLoader.class);

    public XFire loadConfig(String configPath, ServletContext servletCtx) throws XFireException {
        if (configPath == null) {
            throw new XFireException("Configuration file required");
        }
        ApplicationContext parent = null;
        ClassPathXmlApplicationContext newCtx = null;
        if (servletCtx != null) {
            parent = (ApplicationContext)servletCtx.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        String[] configFiles = null;
        configPath = parent == null || !parent.containsBean("xfire") ? "org/codehaus/xfire/spring/xfire.xml," + configPath : "org/codehaus/xfire/spring/customEditors.xml," + configPath;
        configFiles = configPath.indexOf(",") != -1 ? configPath.split(",") : new String[]{configPath};
        newCtx = parent != null ? new ClassPathXmlApplicationContext(configFiles, parent) : new ClassPathXmlApplicationContext(configFiles);
        if (servletCtx != null && servletCtx.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE) == null) {
            servletCtx.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)newCtx);
        }
        XFire xfire = (XFire)newCtx.getBean("xfire");
        this.log.debug((Object)("Setting XFire instance: " + xfire));
        XFireFactory.newInstance().setXFire(xfire);
        return xfire;
    }
}

