/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.soap.handler.SoapSerializerHandler;
import org.codehaus.xfire.util.DOMUtils;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.util.dom.DOMSerializer;
import org.w3c.dom.Document;

public class DOMOutHandler
extends AbstractHandler {
    public static final String DOM_MESSAGE = "dom.message";

    public DOMOutHandler() {
        this.setPhase("post-invoke");
        this.after(SoapSerializerHandler.class.getName());
    }

    public void invoke(MessageContext context) throws Exception {
        OutMessage message = context.getOutMessage();
        ByteArrayInputStream inStream = new ByteArrayInputStream(this.getMessageBytes(message, context));
        Document doc = DOMUtils.readXml(inStream);
        message.setProperty(DOM_MESSAGE, doc);
        message.setSerializer(new DOMSerializer(doc));
    }

    private byte[] getMessageBytes(OutMessage message, MessageContext context) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLStreamWriter byteArrayWriter = STAXUtils.createXMLStreamWriter(outputStream, null, context);
        message.getSerializer().writeMessage(message, byteArrayWriter, context);
        byteArrayWriter.flush();
        return outputStream.toByteArray();
    }
}

