/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.xmpp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.soap.SoapTransport;
import org.codehaus.xfire.soap.SoapTransportHelper;
import org.codehaus.xfire.transport.AbstractTransport;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.DefaultEndpoint;
import org.codehaus.xfire.wsdl11.WSDL11Transport;
import org.codehaus.xfire.xmpp.SoapIQProvider;
import org.codehaus.xfire.xmpp.XMPPChannel;
import org.codehaus.xfire.xmpp.XMPPFaultHandler;

public class XMPPTransport
extends AbstractTransport
implements SoapTransport,
WSDL11Transport {
    private static final Log log = LogFactory.getLog((Class)XMPPTransport.class);
    public static final String NAME = "XMPP";
    public static final String BINDING_ID = "http://jabber.org/protocol/soap";
    private XFire xfire;
    private String username;
    private String password;
    private String server;
    private String id;

    public XMPPTransport(XFire xfire, String server, String username, String password) {
        this.username = username;
        this.password = password;
        this.server = server;
        this.xfire = xfire;
        this.id = username + "@" + server;
        new SoapIQProvider();
        this.addFaultHandler(new XMPPFaultHandler());
        SoapTransportHelper.createSoapTransport(this);
    }

    public String getName() {
        return NAME;
    }

    public String getServiceURL(Service service) {
        try {
            return this.id + "/" + service.getSimpleName();
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't create the channel.", e);
        }
    }

    public String getTransportURI(Service service) {
        return BINDING_ID;
    }

    protected Channel createNewChannel(String uri) {
        log.debug((Object)("Creating new channel for uri: " + uri));
        XMPPChannel c = new XMPPChannel(uri, this);
        c.setEndpoint(new DefaultEndpoint());
        return c;
    }

    protected String getUriPrefix() {
        return this.id;
    }

    public String getPassword() {
        return this.password;
    }

    public XFire getXFire() {
        return this.xfire;
    }

    public String getServer() {
        return this.server;
    }

    public String getUsername() {
        return this.username;
    }

    public String[] getSupportedBindings() {
        return new String[]{BINDING_ID};
    }

    public String[] getKnownUriSchemes() {
        return new String[]{"xmpp://"};
    }
}

