/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.client;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.client.ClientFaultConverter;
import org.codehaus.xfire.client.Correlator;
import org.codehaus.xfire.client.CorrelatorHandler;
import org.codehaus.xfire.client.Invocation;
import org.codehaus.xfire.client.MessageIdCorrelator;
import org.codehaus.xfire.client.XFireProxy;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandlerSupport;
import org.codehaus.xfire.handler.HandlerPipeline;
import org.codehaus.xfire.handler.OutMessageSender;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.soap.AbstractSoapBinding;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.ChannelEndpoint;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.wsdl11.parser.WSDLServiceBuilder;
import org.xml.sax.InputSource;

public class Client
extends AbstractHandlerSupport
implements ChannelEndpoint {
    private static final Log log = LogFactory.getLog((Class)Client.class);
    public static final String CLIENT_MODE = "client.mode";
    private Set invocations = Collections.synchronizedSet(new HashSet());
    private Channel outChannel;
    private Transport transport;
    private Service service;
    private Binding binding;
    private String url;
    private int timeout = 10000;
    private String endpointUri;
    private CorrelatorHandler correlatorHandler;
    private Correlator correlator;
    private XFire xfire = XFireFactory.newInstance().getXFire();

    protected Client() {
        this.addOutHandler(new OutMessageSender());
        this.addFaultHandler(new ClientFaultConverter());
        this.correlator = new MessageIdCorrelator();
        this.correlatorHandler = new CorrelatorHandler(this.invocations);
        this.correlatorHandler.setCorrelator(this.correlator);
        this.addInHandler(this.correlatorHandler);
        this.addFaultHandler(this.correlatorHandler);
    }

    public Client(Transport t, Endpoint endpoint) {
        this(endpoint.getBinding(), t, endpoint.getBinding().getService(), endpoint.getUrl(), null);
    }

    public Client(Binding binding, String url) {
        this(binding, XFireFactory.newInstance().getXFire().getTransportManager().getTransport(binding.getBindingId()), binding.getService(), url, null);
    }

    public Client(Transport t, Binding binding, String url) {
        this(binding, t, binding.getService(), url, null);
    }

    public Client(Transport transport, Service service, String url) {
        this(transport, service, url, null);
    }

    public Client(Transport transport, Service service, String url, String endpointUri) {
        this();
        this.transport = transport;
        this.url = url;
        this.endpointUri = endpointUri;
        this.setService(service);
        this.binding = this.findBinding(transport, service);
    }

    public Client(Binding binding, Transport transport, Service service, String url, String endpointUri) {
        this();
        this.transport = transport;
        this.url = url;
        this.endpointUri = endpointUri;
        this.setService(service);
        this.binding = binding;
    }

    public Client(Definition definition, Class serviceClass) throws Exception {
        this();
        this.initFromDefinition("http://schemas.xmlsoap.org/soap/http", definition, serviceClass);
    }

    public Client(String binding, Definition definition, Class serviceClass) throws Exception {
        this();
        this.initFromDefinition(binding, definition, serviceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client(InputStream is, Class serviceClass) throws Exception {
        this();
        try {
            InputSource src = new InputSource(is);
            Definition def = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, src);
            this.initFromDefinition("http://schemas.xmlsoap.org/soap/http", def, serviceClass);
        }
        finally {
            is.close();
        }
    }

    public Client(URL wsdlLocation) throws Exception {
        this(wsdlLocation.openStream(), null);
    }

    public Client(URL wsdlLocation, Class serviceClass) throws Exception {
        this(wsdlLocation.openStream(), serviceClass);
    }

    private void setService(Service service) {
        this.service = service;
        this.service.setFaultSerializer(service.getFaultSerializer());
    }

    protected void initFromDefinition(String binding, Definition definition, Class serviceClass) throws Exception {
        WSDLServiceBuilder builder = new WSDLServiceBuilder(definition);
        builder.setTransportManager(this.xfire.getTransportManager());
        builder.build();
        Endpoint ep = this.findEndpoint(binding, builder.getAllServices());
        this.url = ep.getUrl();
        this.binding = ep.getBinding();
        this.transport = this.getXFire().getTransportManager().getTransport(binding);
        if (serviceClass != null) {
            ep.getBinding().getService().getServiceInfo().setServiceClass(serviceClass);
        }
        this.setService(ep.getBinding().getService());
    }

    public Endpoint findEndpoint(String binding, Collection services) {
        Iterator itr = services.iterator();
        while (itr.hasNext()) {
            Service service = (Service)itr.next();
            Iterator eitr = service.getEndpoints().iterator();
            while (eitr.hasNext()) {
                Endpoint ep = (Endpoint)eitr.next();
                if (!ep.getBinding().getBindingId().equals(binding)) continue;
                return ep;
            }
        }
        return null;
    }

    private Binding findBinding(Transport transport, Service service) {
        String[] ids = transport.getSupportedBindings();
        for (int i = 0; i < ids.length; ++i) {
            Binding b = service.getBinding(ids[i]);
            if (b == null) continue;
            return b;
        }
        return this.findSoapBinding(service);
    }

    private AbstractSoapBinding findSoapBinding(Service service) {
        Iterator itr = service.getBindings().iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof AbstractSoapBinding)) continue;
            return (AbstractSoapBinding)o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] invoke(OperationInfo op, Object[] params) throws Exception {
        Invocation call = new Invocation(this);
        try {
            this.invocations.add(call);
            Object[] objectArray = call.invoke(op, params);
            return objectArray;
        }
        finally {
            this.invocations.remove(call);
        }
    }

    public Object[] invoke(String name, Object[] params) throws Exception {
        OperationInfo op = this.service.getServiceInfo().getOperation(name);
        if (op == null) {
            throw new XFireRuntimeException("Could not find operation with name " + name);
        }
        return this.invoke(op, params);
    }

    public void onReceive(MessageContext context, InMessage msg) {
        MessageExchange exchange;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received message to " + msg.getUri()));
        }
        if (context.getExchange() == null) {
            new MessageExchange(context);
        }
        if ((exchange = context.getExchange()) == null) {
            exchange = new MessageExchange(context);
        }
        if (exchange.getOperation() != null && "urn:xfire:mep:in".equals(exchange.getOperation().getMEP())) {
            return;
        }
        exchange.setInMessage(msg);
        context.setCurrentMessage(msg);
        context.setService(this.service);
        try {
            HandlerPipeline inPipe = new HandlerPipeline(this.getXFire().getInPhases());
            inPipe.addHandlers(this.getInHandlers());
            inPipe.addHandlers(this.getTransport().getInHandlers());
            context.setInPipeline(inPipe);
            inPipe.invoke(context);
        }
        catch (Exception e1) {
            XFireFault fault = XFireFault.createFault(e1);
            AbstractMessage faultMsg = context.getExchange().getFaultMessage();
            faultMsg.setBody(fault);
            context.setCurrentMessage(faultMsg);
            HandlerPipeline inPipe = new HandlerPipeline(this.getXFire().getInPhases());
            inPipe.addHandlers(this.getFaultHandlers());
            inPipe.addHandlers(this.getTransport().getFaultHandlers());
            context.setInPipeline(inPipe);
            try {
                inPipe.invoke(context);
            }
            catch (Exception e) {
                if (e instanceof XFireRuntimeException) {
                    throw (XFireRuntimeException)e;
                }
                throw new XFireRuntimeException("Could not receive fault.", e);
            }
        }
    }

    public Channel getOutChannel() {
        if (this.outChannel != null) {
            return this.outChannel;
        }
        try {
            String uri = this.getEndpointUri();
            this.outChannel = uri == null ? this.getTransport().createChannel() : this.getTransport().createChannel(uri);
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't open channel.", e);
        }
        this.outChannel.setEndpoint(this);
        return this.outChannel;
    }

    public void close() {
        if (this.outChannel != null) {
            this.outChannel.close();
        }
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public Service getService() {
        return this.service;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public XFire getXFire() {
        return this.xfire;
    }

    public void setXFire(XFire xfire) {
        this.xfire = xfire;
    }

    public static Client getInstance(Object service) {
        InvocationHandler proxy = Proxy.getInvocationHandler(service);
        if (proxy == null || !(proxy instanceof XFireProxy)) {
            throw new IllegalArgumentException("Argument is not an XFireProxy");
        }
        return ((XFireProxy)proxy).getClient();
    }

    Binding getBinding() {
        return this.binding;
    }
}

