/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveType {
    private static final Map<String, PrimitiveType> instancesByName = new HashMap<String, PrimitiveType>();
    private static final Map<Class<?>, PrimitiveType> instancesByJavaType = new HashMap();
    public static final PrimitiveType BYTE_P = new PrimitiveType("byte", Byte.TYPE);
    public static final PrimitiveType BYTE = new PrimitiveType("byte", Byte.class);
    public static final PrimitiveType SHORT_P = new PrimitiveType("short", Short.TYPE);
    public static final PrimitiveType SHORT = new PrimitiveType("short", Short.class);
    public static final PrimitiveType INT_P = new PrimitiveType("int", Integer.TYPE);
    public static final PrimitiveType INT = new PrimitiveType("int", Integer.class);
    public static final PrimitiveType LONG_P = new PrimitiveType("long", Long.TYPE);
    public static final PrimitiveType LONG = new PrimitiveType("long", Long.class);
    public static final PrimitiveType BIG_INTEGER = new PrimitiveType("big_integer", BigInteger.class);
    public static final PrimitiveType FLOAT_P = new PrimitiveType("float", Float.TYPE);
    public static final PrimitiveType FLOAT = new PrimitiveType("float", Float.class);
    public static final PrimitiveType DOUBLE_P = new PrimitiveType("double", Double.TYPE);
    public static final PrimitiveType DOUBLE = new PrimitiveType("double", Double.class);
    public static final PrimitiveType BIG_DECIMAL = new PrimitiveType("big_decimal", BigDecimal.class);
    public static final PrimitiveType BOOLEAN_P = new PrimitiveType("boolean", Boolean.TYPE);
    public static final PrimitiveType BOOLEAN = new PrimitiveType("boolean", Boolean.class);
    public static final PrimitiveType STRING = new PrimitiveType("string", String.class);
    public static final PrimitiveType DATE = new PrimitiveType("date", Date.class);
    public static final PrimitiveType TIME = new PrimitiveType("time", Time.class);
    public static final PrimitiveType TIMESTAMP = new PrimitiveType("timestamp", Timestamp.class);
    public static final PrimitiveType OBJECT = new PrimitiveType("object", Object.class);
    public static final PrimitiveType BINARY = new PrimitiveType("binary", byte[].class);
    public static final PrimitiveType ARRAY = new PrimitiveType("array", Object[].class);
    private String name;
    private Class<?> javaType;

    public PrimitiveType(String name, Class<?> javaType) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (javaType == null) {
            throw new IllegalArgumentException("javaType is null");
        }
        this.name = name;
        this.javaType = javaType;
        instancesByName.put(name, this);
        instancesByJavaType.put(javaType, this);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public static PrimitiveType getInstance(String name) {
        return instancesByName.get(name);
    }

    public static PrimitiveType findByJavaType(Class<?> javaType) {
        return instancesByJavaType.get(javaType);
    }

    public static Collection<PrimitiveType> getInstances() {
        return instancesByName.values();
    }

    public String toString() {
        return this.name;
    }
}

