/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script;

import java.util.HashSet;
import java.util.Set;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.accessor.FeatureAccessor;
import org.databene.commons.bean.DefaultClassProvider;
import org.databene.script.BeanSpec;
import org.databene.script.DatabeneScriptParser;
import org.databene.script.expression.DynamicExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNExpression
extends DynamicExpression<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabeneScriptParser.class);
    private static Set<String> noClasses = new HashSet<String>(1000);
    private String[] qnParts;

    public QNExpression(String[] qnParts) {
        this.qnParts = qnParts;
    }

    @Override
    public Object evaluate(Context context) {
        try {
            return QNExpression.resolveNamePart(this.qnParts, this.qnParts.length, context);
        }
        catch (ObjectNotFoundException e) {
            throw new ObjectNotFoundException("Unable to resolve " + ArrayFormat.format((String)".", (Object[])this.qnParts));
        }
    }

    public static Object resolveNamePart(String[] qnParts, int qnLength, Context context) {
        String objectOrClassName = ArrayFormat.formatPart((String)".", (int)0, (int)qnLength, (Object[])qnParts);
        if (context.contains(objectOrClassName)) {
            return context.get(objectOrClassName);
        }
        if (!noClasses.contains(objectOrClassName)) {
            try {
                return DefaultClassProvider.resolveByObjectOrDefaultInstance((String)objectOrClassName, (Object)context);
            }
            catch (ConfigurationError e) {
                // empty catch block
            }
        }
        LOGGER.debug("Class not found: " + objectOrClassName);
        noClasses.add(objectOrClassName);
        if (qnLength > 1) {
            return QNExpression.readField(qnParts, qnLength - 1, qnParts[qnLength - 1], context);
        }
        throw new ObjectNotFoundException("'" + objectOrClassName + "' is not defined");
    }

    private static Object readField(String[] qnParts, int qnLength, String fieldName, Context context) {
        return FeatureAccessor.getValue((Object)QNExpression.resolveNamePart(qnParts, qnLength, context), (String)fieldName);
    }

    public BeanSpec resolve(Context context) {
        String qn = ArrayFormat.format((String)".", (Object[])this.qnParts);
        if (context.contains(qn)) {
            return BeanSpec.createReference(context.get(qn));
        }
        if (!noClasses.contains(qn)) {
            try {
                Class bean = DefaultClassProvider.resolveByObjectOrDefaultInstance((String)qn, (Object)context);
                return BeanSpec.createConstruction(bean);
            }
            catch (ConfigurationError e) {
                // empty catch block
            }
        }
        LOGGER.debug("Class not found: " + qn);
        noClasses.add(qn);
        Object bean = QNExpression.readField(this.qnParts, this.qnParts.length - 1, (String)ArrayUtil.lastElementOf((Object[])this.qnParts), context);
        return BeanSpec.createReference(bean);
    }

    public String toString() {
        return ArrayFormat.format((String)".", (Object[])this.qnParts);
    }
}

