/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script;

import java.util.Arrays;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.bean.DefaultClassProvider;
import org.databene.script.Expression;
import org.databene.script.QNExpression;
import org.databene.script.expression.DynamicExpression;
import org.databene.script.expression.ExpressionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNInvocationExpression
extends DynamicExpression<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QNInvocationExpression.class);
    private String[] qn;
    private Expression<?>[] argExpressions;

    public QNInvocationExpression(String[] qn, Expression<?>[] argExpressions) {
        this.qn = qn;
        this.argExpressions = argExpressions;
    }

    @Override
    public Object evaluate(Context context) {
        Object[] args = ExpressionUtil.evaluateAll(this.argExpressions, context);
        String methodName = (String)ArrayUtil.lastElementOf((Object[])this.qn);
        return this.invoke(this.qn, this.qn.length - 1, methodName, args, context);
    }

    private Object invoke(String[] qn, int qnLength, String methodName, Object[] args, Context context) {
        String objectOrClassName = ArrayFormat.formatPart((String)".", (int)0, (int)qnLength, (Object[])qn);
        if (context.contains(objectOrClassName)) {
            Object target = context.get(objectOrClassName);
            return BeanUtil.invoke((Object)target, (String)methodName, (Object[])args);
        }
        try {
            Class type = DefaultClassProvider.resolveByObjectOrDefaultInstance((String)objectOrClassName, (Object)context);
            return BeanUtil.invokeStatic((Class)type, (String)methodName, (boolean)false, (Object[])args);
        }
        catch (ConfigurationError e) {
            QNExpression ownerEx;
            Object owner;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Class not found: " + objectOrClassName);
            }
            if ((owner = (ownerEx = new QNExpression(Arrays.copyOfRange(qn, 0, qnLength))).evaluate(context)) != null) {
                return BeanUtil.invoke((boolean)false, (Object)owner, (String)methodName, (Object[])args);
            }
            throw new UnsupportedOperationException("Cannot evaluate " + objectOrClassName);
        }
    }

    public String toString() {
        return ArrayFormat.format((String)".", (Object[])this.qn) + '(' + ArrayFormat.format((Object[])this.argExpressions) + ')';
    }
}

