/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.expression;

import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;
import org.databene.script.Expression;
import org.databene.script.expression.WrapperExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeExpression<S, R>
implements WrapperExpression<R> {
    protected String symbol;
    protected Expression<S>[] terms;

    protected CompositeExpression(Expression<S> ... terms) {
        this((String)null, terms);
    }

    protected CompositeExpression(String symbol, Expression<S> ... terms) {
        this.symbol = symbol;
        this.terms = terms;
    }

    public Expression<S>[] getTerms() {
        return this.terms;
    }

    @Override
    public Expression<?>[] getSourceExpressions() {
        return this.getTerms();
    }

    public void addTerm(Expression<S> term) {
        this.terms = (Expression[])ArrayUtil.append(term, (Object[])this.terms);
    }

    @Override
    public boolean isConstant() {
        for (Expression<S> term : this.terms) {
            if (term.isConstant()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "(" + ArrayFormat.format((String)(" " + this.symbol + " "), (Object[])this.terms) + ")";
    }
}

