/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.expression;

import org.databene.commons.Context;
import org.databene.script.Expression;
import org.databene.script.expression.CompositeExpression;
import org.databene.script.math.ArithmeticEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InRangeExpression
extends CompositeExpression<Object, Boolean> {
    public InRangeExpression(Expression value, Expression min, Expression max) {
        super(value, min, max);
    }

    @Override
    public Boolean evaluate(Context context) {
        Object value = this.terms[0].evaluate(context);
        Object minValue = this.terms[1].evaluate(context);
        Object maxValue = this.terms[2].evaluate(context);
        return ArithmeticEngine.defaultInstance().lessOrEquals(minValue, value) && ArithmeticEngine.defaultInstance().lessOrEquals(value, maxValue);
    }

    @Override
    public String toString() {
        return "(" + this.terms[0] + " <= " + this.terms[1] + " <= " + this.terms[2] + ")";
    }
}

