/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.expression;

import org.databene.commons.ArrayFormat;
import org.databene.commons.BeanUtil;
import org.databene.commons.Context;
import org.databene.script.Expression;
import org.databene.script.expression.Construction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedConstruction<E>
extends Construction<E> {
    private Expression<?>[] argumentExpressions;

    public ParameterizedConstruction(String className, Expression<?>[] argumentExpressions) {
        super(className);
        this.argumentExpressions = argumentExpressions;
    }

    @Override
    public E evaluate(Context context) {
        Class type = this.getType(context);
        Object[] arguments = new Object[this.argumentExpressions.length];
        for (int i = 0; i < this.argumentExpressions.length; ++i) {
            arguments[i] = this.argumentExpressions[i].evaluate(context);
        }
        return (E)BeanUtil.newInstance(type, (boolean)false, (Object[])arguments);
    }

    public boolean classExists(Context context) {
        try {
            this.getType(context);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return "new " + this.className + '(' + ArrayFormat.format((String)", ", (Object[])this.argumentExpressions) + ')';
    }
}

