/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.expression;

import org.databene.commons.Assert;
import org.databene.commons.Context;
import org.databene.script.Expression;
import org.databene.script.expression.CompositeExpression;
import org.databene.script.math.ArithmeticEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SumExpression
extends CompositeExpression<Object, Object> {
    public SumExpression() {
        this("+", new Expression[0]);
    }

    public SumExpression(Expression ... terms) {
        this("+", terms);
    }

    public SumExpression(String symbol, Expression ... terms) {
        super(symbol, terms);
    }

    @Override
    public Object evaluate(Context context) {
        Expression[] summands = new Expression[]{this.terms[0], this.terms[1]};
        Assert.isTrue((summands.length > 1 ? 1 : 0) != 0, (String)"At least two summands needed");
        Object result = summands[0].evaluate(context);
        for (int i = 1; i < summands.length; ++i) {
            result = ArithmeticEngine.defaultInstance().add(result, summands[i].evaluate(context));
        }
        return result;
    }
}

