/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.math;

import java.util.Date;
import org.databene.commons.BeanUtil;
import org.databene.commons.TimeUtil;
import org.databene.script.math.TypeArithmetic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateArithmetic
extends TypeArithmetic<Date> {
    public DateArithmetic() {
        super(Date.class);
    }

    @Override
    public Date add(Object summand1, Object summand2) {
        if (summand1 instanceof Date) {
            return this.addImpl((Date)summand1, summand2);
        }
        if (summand2 instanceof Date) {
            return this.addImpl((Date)summand2, summand1);
        }
        throw new IllegalArgumentException("No argument is of type " + this.baseType + ": " + summand1 + ", " + summand2);
    }

    @Override
    public Object subtract(Object minuend, Object subtrahend) {
        return this.subtractImpl((Date)minuend, subtrahend);
    }

    @Override
    public Object multiply(Object factor1, Object factor2) {
        throw new UnsupportedOperationException("Cannot multiply dates");
    }

    @Override
    public Object divide(Object quotient, Object divisor) {
        throw new UnsupportedOperationException("Cannot divide dates");
    }

    private Date addImpl(Date summand1, Object summand2) {
        if (summand2 instanceof Number) {
            return new Date(summand1.getTime() + ((Number)summand2).longValue());
        }
        if (summand2 instanceof Date) {
            return TimeUtil.add((Date)summand1, (Date)((Date)summand2));
        }
        throw new IllegalArgumentException("Cannot add " + BeanUtil.simpleClassName((Object)summand2) + " to " + this.baseType.getClass().getName());
    }

    private Object subtractImpl(Date minuend, Object subtrahend) {
        if (subtrahend instanceof Number) {
            return new Date(minuend.getTime() - ((Number)subtrahend).longValue());
        }
        if (subtrahend instanceof Date) {
            return TimeUtil.subtract((Date)minuend, (Date)((Date)subtrahend));
        }
        throw new IllegalArgumentException("Cannot subtract " + BeanUtil.simpleClassName((Object)subtrahend) + " from " + minuend.getClass().getName());
    }
}

