/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.math;

import java.sql.Time;
import java.util.Date;
import org.databene.commons.BeanUtil;
import org.databene.commons.TimeUtil;
import org.databene.script.math.TypeArithmetic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeArithmetic
extends TypeArithmetic<Time> {
    public TimeArithmetic() {
        super(Time.class);
    }

    @Override
    public Time add(Object summand1, Object summand2) {
        if (summand1 instanceof Time) {
            return this.addImpl((Time)summand1, summand2);
        }
        if (summand2 instanceof Number) {
            return this.addImpl((Time)summand2, summand1);
        }
        throw new IllegalArgumentException("No argument is of type " + this.baseType + ": " + summand1 + ", " + summand2);
    }

    @Override
    public Object subtract(Object minuend, Object subtrahend) {
        if (minuend instanceof Date) {
            long minuendMillis = ((Date)minuend).getTime();
            if (subtrahend instanceof Date) {
                return new Time(minuendMillis - TimeUtil.millisSinceOwnEpoch((Date)((Date)subtrahend)));
            }
            if (subtrahend instanceof Number) {
                return new Time(minuendMillis - ((Number)subtrahend).longValue());
            }
            throw new IllegalArgumentException("Subtrahend must be Date, Time, Timestamp or Number, but was: " + subtrahend.getClass().getName());
        }
        throw new IllegalArgumentException("Minuend needs to be of type " + this.baseType + ", but was: " + minuend.getClass().getName());
    }

    @Override
    public Object multiply(Object factor1, Object factor2) {
        throw new UnsupportedOperationException("Cannot multiply times");
    }

    @Override
    public Object divide(Object quotient, Object divisor) {
        throw new UnsupportedOperationException("Cannot divide times");
    }

    private Time addImpl(Time summand1, Object summand2) {
        if (summand2 instanceof Number) {
            return new Time(summand1.getTime() + ((Number)summand2).longValue());
        }
        if (summand2 instanceof Date) {
            return new Time(summand1.getTime() + TimeUtil.millisSinceOwnEpoch((Date)((Date)summand2)));
        }
        throw new IllegalArgumentException("Cannot add " + BeanUtil.simpleClassName((Object)summand2) + " to java.util.Date");
    }
}

