/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.jdo.JDOUserCallbackException;
import javax.jdo.listener.AttachCallback;
import javax.jdo.listener.AttachLifecycleListener;
import javax.jdo.listener.ClearCallback;
import javax.jdo.listener.ClearLifecycleListener;
import javax.jdo.listener.CreateLifecycleListener;
import javax.jdo.listener.DeleteCallback;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.DetachCallback;
import javax.jdo.listener.DetachLifecycleListener;
import javax.jdo.listener.DirtyLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.LoadCallback;
import javax.jdo.listener.LoadLifecycleListener;
import javax.jdo.listener.StoreCallback;
import javax.jdo.listener.StoreLifecycleListener;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.jdo.FieldInstanceLifecycleEvent;
import org.datanucleus.api.jdo.LifecycleListenerForClass;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.util.Localiser;

public class JDOCallbackHandler
implements CallbackHandler {
    NucleusContext nucleusCtx;
    private final Map<InstanceLifecycleListener, LifecycleListenerForClass> listeners = new IdentityHashMap<InstanceLifecycleListener, LifecycleListenerForClass>(1);
    private List<LifecycleListenerForClass> listenersWorkingCopy = null;
    CallbackHandler beanValidationHandler;

    public JDOCallbackHandler(NucleusContext nucleusCtx) {
        this.nucleusCtx = nucleusCtx;
    }

    public void setValidationListener(CallbackHandler handler) {
        this.beanValidationHandler = handler;
    }

    public void postCreate(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof CreateLifecycleListener)) continue;
            ((CreateLifecycleListener)listener.getListener()).postCreate(new InstanceLifecycleEvent(pc, 0, null));
        }
    }

    public void prePersist(Object pc) {
        if (this.beanValidationHandler != null) {
            this.beanValidationHandler.prePersist(pc);
        }
    }

    public void preStore(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof StoreLifecycleListener)) continue;
            ExecutionContext ec = this.nucleusCtx.getApiAdapter().getExecutionContext(pc);
            String[] fieldNames = null;
            ObjectProvider op = ec.findObjectProvider(pc);
            fieldNames = op.getDirtyFieldNames();
            if (fieldNames == null) {
                fieldNames = op.getLoadedFieldNames();
            }
            ((StoreLifecycleListener)listener.getListener()).preStore((InstanceLifecycleEvent)new FieldInstanceLifecycleEvent(pc, 2, null, fieldNames));
        }
        if (pc instanceof StoreCallback) {
            try {
                ((StoreCallback)pc).jdoPreStore();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPreStore"}), (Throwable)e);
            }
        }
        if (this.beanValidationHandler != null) {
            this.beanValidationHandler.prePersist(pc);
        }
    }

    public void postStore(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof StoreLifecycleListener)) continue;
            ((StoreLifecycleListener)listener.getListener()).postStore(new InstanceLifecycleEvent(pc, 2, null));
        }
    }

    public void preClear(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof ClearLifecycleListener)) continue;
            ((ClearLifecycleListener)listener.getListener()).preClear(new InstanceLifecycleEvent(pc, 3, null));
        }
        if (pc instanceof ClearCallback) {
            try {
                ((ClearCallback)pc).jdoPreClear();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPreClear"}), (Throwable)e);
            }
        }
    }

    public void postClear(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof ClearLifecycleListener)) continue;
            ((ClearLifecycleListener)listener.getListener()).postClear(new InstanceLifecycleEvent(pc, 3, null));
        }
    }

    public void preDelete(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DeleteLifecycleListener)) continue;
            ((DeleteLifecycleListener)listener.getListener()).preDelete(new InstanceLifecycleEvent(pc, 4, null));
        }
        if (pc instanceof DeleteCallback) {
            try {
                ((DeleteCallback)pc).jdoPreDelete();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPreDelete"}), (Throwable)e);
            }
        }
        if (this.beanValidationHandler != null) {
            this.beanValidationHandler.preDelete(pc);
        }
    }

    public void postDelete(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DeleteLifecycleListener)) continue;
            ((DeleteLifecycleListener)listener.getListener()).postDelete(new InstanceLifecycleEvent(pc, 4, null));
        }
    }

    public void preDirty(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DirtyLifecycleListener)) continue;
            ((DirtyLifecycleListener)listener.getListener()).preDirty(new InstanceLifecycleEvent(pc, 5, null));
        }
    }

    public void postDirty(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DirtyLifecycleListener)) continue;
            ((DirtyLifecycleListener)listener.getListener()).postDirty(new InstanceLifecycleEvent(pc, 5, null));
        }
    }

    public void postLoad(Object pc) {
        if (pc instanceof LoadCallback) {
            try {
                ((LoadCallback)pc).jdoPostLoad();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPostLoad"}), (Throwable)e);
            }
        }
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof LoadLifecycleListener)) continue;
            ((LoadLifecycleListener)listener.getListener()).postLoad(new InstanceLifecycleEvent(pc, 1, null));
        }
    }

    public void postRefresh(Object pc) {
    }

    public void preDetach(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DetachLifecycleListener)) continue;
            ((DetachLifecycleListener)listener.getListener()).preDetach(new InstanceLifecycleEvent(pc, 6, null));
        }
        if (pc instanceof DetachCallback) {
            try {
                ((DetachCallback)pc).jdoPreDetach();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPreDetach"}), (Throwable)e);
            }
        }
    }

    public void postDetach(Object pc, Object detachedPC) {
        if (pc instanceof DetachCallback) {
            try {
                ((DetachCallback)detachedPC).jdoPostDetach(pc);
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPostDetach"}), (Throwable)e);
            }
        }
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DetachLifecycleListener)) continue;
            ((DetachLifecycleListener)listener.getListener()).postDetach(new InstanceLifecycleEvent(detachedPC, 6, pc));
        }
    }

    public void preAttach(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof AttachLifecycleListener)) continue;
            ((AttachLifecycleListener)listener.getListener()).preAttach(new InstanceLifecycleEvent(pc, 7, null));
        }
        if (pc instanceof AttachCallback) {
            try {
                ((AttachCallback)pc).jdoPreAttach();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPreAttach"}), (Throwable)e);
            }
        }
    }

    public void postAttach(Object pc, Object detachedPC) {
        if (pc instanceof AttachCallback) {
            try {
                ((AttachCallback)pc).jdoPostAttach(detachedPC);
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(Localiser.msg((String)"025001", (Object[])new Object[]{"jdoPostAttach"}), (Throwable)e);
            }
        }
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof AttachLifecycleListener)) continue;
            ((AttachLifecycleListener)listener.getListener()).postAttach(new InstanceLifecycleEvent(pc, 7, detachedPC));
        }
    }

    public void addListener(Object listener, Class[] classes) {
        if (listener == null) {
            return;
        }
        InstanceLifecycleListener jdoListener = (InstanceLifecycleListener)listener;
        LifecycleListenerForClass entry = this.listeners.containsKey(jdoListener) ? this.listeners.get(jdoListener).mergeClasses(classes) : new LifecycleListenerForClass(jdoListener, classes);
        this.listeners.put(jdoListener, entry);
        this.listenersWorkingCopy = null;
    }

    public void removeListener(Object listener) {
        if (this.listeners.remove(listener) != null) {
            this.listenersWorkingCopy = null;
        }
    }

    public void close() {
        this.listeners.clear();
        this.listenersWorkingCopy = null;
    }

    protected List<LifecycleListenerForClass> getListenersWorkingCopy() {
        if (this.listenersWorkingCopy == null) {
            this.listenersWorkingCopy = new ArrayList<LifecycleListenerForClass>(this.listeners.values());
        }
        return this.listenersWorkingCopy;
    }
}

