/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.java8.converters;

import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class InstantDateConverter
implements TypeConverter<Instant, Date> {
    private static final long serialVersionUID = 1012730202932240062L;

    public Instant toMemberType(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant();
    }

    public Date toDatastoreType(Instant inst) {
        if (inst == null) {
            return null;
        }
        return Date.from(inst.atZone(ZoneId.systemDefault()).toInstant());
    }
}

