/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa.metadata;

import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetadataFileType;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.metadata.xml.AbstractMetaDataHandler;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class JPAMetaDataHandler
extends AbstractMetaDataHandler {
    String defaultPackageName = null;
    boolean metaDataComplete = false;
    boolean defaultCascadePersist = false;
    boolean propertyAccess = false;
    String queryResultEntityName = null;

    public JPAMetaDataHandler(MetaDataManager mgr, String filename, EntityResolver resolver) {
        super(mgr, filename, resolver);
        this.metadata = new FileMetaData();
        ((FileMetaData)this.metadata).setFilename(filename);
        ((FileMetaData)this.metadata).setMetaDataManager(mgr);
        this.pushStack(this.metadata);
    }

    protected ClassMetaData newClassObject(PackageMetaData pmd, Attributes attrs, boolean embeddedOnly) {
        String className = this.getAttr(attrs, "class");
        if (className.indexOf(46) > 0) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        ClassMetaData cmd = new ClassMetaData(pmd, className);
        cmd.setEntityName(this.getAttr(attrs, "name"));
        cmd.setRequiresExtent(true);
        cmd.setDetachable(true);
        cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
        cmd.setEmbeddedOnly(embeddedOnly);
        cmd.setIdentityType(embeddedOnly ? IdentityType.NONDURABLE : IdentityType.APPLICATION);
        String classMetaDataComplete = this.getAttr(attrs, "metadata-complete");
        if (this.metaDataComplete || classMetaDataComplete != null && classMetaDataComplete.equalsIgnoreCase("true")) {
            cmd.setMetaDataComplete();
        }
        return cmd;
    }

    protected AbstractMemberMetaData newFieldObject(AbstractClassMetaData acmd, Attributes attrs) {
        String fetch = this.getAttr(attrs, "fetch");
        String dfg = "true";
        if (fetch != null && fetch.equalsIgnoreCase("LAZY")) {
            dfg = "false";
        }
        Object mmd = null;
        mmd = acmd.getMetaDataForMember(this.getAttr(attrs, "name"));
        if (mmd != null) {
            String depString;
            if (dfg != null) {
                mmd.setDefaultFetchGroup(dfg.equals("true"));
            }
            if (!StringUtils.isWhitespace((String)(depString = this.getAttr(attrs, "dependent")))) {
                mmd.setDependent(depString.trim().equalsIgnoreCase("true"));
            }
            mmd.setMappedBy(this.getAttr(attrs, "mapped-by"));
            String loadFg = this.getAttr(attrs, "load-fetch-group");
            if (!StringUtils.isWhitespace((String)loadFg)) {
                mmd.setLoadFetchGroup(loadFg);
            }
        } else {
            mmd = this.propertyAccess ? new PropertyMetaData((MetaData)acmd, this.getAttr(attrs, "name")) : new FieldMetaData((MetaData)acmd, this.getAttr(attrs, "name"));
            mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT.toString());
            mmd.setDefaultFetchGroup(dfg);
            mmd.setDependent(this.getAttr(attrs, "dependent"));
            mmd.setMappedBy(this.getAttr(attrs, "mapped-by"));
            mmd.setLoadFetchGroup(this.getAttr(attrs, "load-fetch-group"));
            acmd.addMember(mmd);
        }
        if (this.defaultCascadePersist) {
            mmd.setCascadePersist(true);
        }
        return mmd;
    }

    protected AbstractMemberMetaData newPKFieldObject(AbstractClassMetaData acmd, Attributes attrs) {
        Object mmd = null;
        mmd = acmd.getMetaDataForMember(this.getAttr(attrs, "name"));
        if (mmd != null) {
            mmd.setPrimaryKey(true);
        } else {
            mmd = this.propertyAccess ? new PropertyMetaData((MetaData)acmd, this.getAttr(attrs, "name")) : new FieldMetaData((MetaData)acmd, this.getAttr(attrs, "name"));
            mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT.toString());
            mmd.setPrimaryKey(true);
            if (this.defaultCascadePersist) {
                mmd.setCascadePersist(true);
            }
            acmd.addMember(mmd);
        }
        return mmd;
    }

    protected AbstractMemberMetaData newTransientFieldObject(MetaData md, String name) {
        Object mmd = null;
        mmd = this.propertyAccess ? new PropertyMetaData(md, name) : new FieldMetaData(md, name);
        mmd.setNotPersistent();
        if (this.defaultCascadePersist) {
            mmd.setCascadePersist(true);
        }
        return mmd;
    }

    protected AbstractMemberMetaData newOverriddenFieldObject(MetaData md, Attributes attrs) {
        Object mmd = null;
        mmd = this.propertyAccess ? new PropertyMetaData(md, "#UNKNOWN." + this.getAttr(attrs, "name")) : new FieldMetaData(md, "#UNKNOWN." + this.getAttr(attrs, "name"));
        mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT.toString());
        if (this.defaultCascadePersist) {
            mmd.setCascadePersist(true);
        }
        return mmd;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        block144: {
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("<" + qName);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    sb.append(" ");
                    sb.append(attrs.getQName(i)).append("=\"").append(attrs.getValue(i)).append("\"");
                }
                sb.append(">");
                NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044034", (Object)sb.toString(), (Object)("" + this.stack.size())));
            }
            if (localName.length() < 1) {
                localName = qName;
            }
            try {
                AbstractMemberMetaData mmd;
                AbstractMemberMetaData fmd;
                ClassMetaData cmd;
                QueryResultMetaData qrmd;
                MetaData md;
                PackageMetaData pmd;
                FileMetaData filemd;
                if (localName.equals("entity-mappings")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(MetadataFileType.JPA_MAPPING_FILE);
                    break block144;
                }
                if (localName.equals("description") || localName.equals("persistence-unit-metadata")) break block144;
                if (localName.equals("xml-mapping-metadata-complete")) {
                    this.metaDataComplete = true;
                    break block144;
                }
                if (localName.equals("persistence-unit-defaults") || localName.equals("package") || localName.equals("schema") || localName.equals("catalog") || localName.equals("access")) break block144;
                if (localName.equals("sequence-generator")) {
                    String allocSize;
                    pmd = null;
                    FileMetaData filemd2 = (FileMetaData)this.metadata;
                    pmd = this.defaultPackageName != null ? filemd2.getPackage(this.defaultPackageName) : (filemd2.getNoOfPackages() > 0 ? filemd2.getPackage(0) : filemd2.newPackageMetadata(""));
                    String initValue = this.getAttr(attrs, "initial-value");
                    if (StringUtils.isWhitespace((String)initValue)) {
                        initValue = "1";
                    }
                    if (StringUtils.isWhitespace((String)(allocSize = this.getAttr(attrs, "allocation-size")))) {
                        allocSize = "50";
                    }
                    SequenceMetaData seqmd = pmd.newSequenceMetadata(this.getAttr(attrs, "name"), null);
                    seqmd.setDatastoreSequence(this.getAttr(attrs, "sequence-name"));
                    seqmd.setInitialValue(initValue);
                    seqmd.setAllocationSize(allocSize);
                    break block144;
                }
                if (localName.equals("table-generator")) {
                    pmd = null;
                    FileMetaData filemd3 = (FileMetaData)this.metadata;
                    pmd = this.defaultPackageName != null ? filemd3.getPackage(this.defaultPackageName) : (filemd3.getNoOfPackages() > 0 ? filemd3.getPackage(0) : filemd3.newPackageMetadata(""));
                    TableGeneratorMetaData tgmd = pmd.newTableGeneratorMetadata(this.getAttr(attrs, "name"));
                    tgmd.setTableName(this.getAttr(attrs, "table"));
                    tgmd.setCatalogName(this.getAttr(attrs, "catalog"));
                    tgmd.setSchemaName(this.getAttr(attrs, "schema"));
                    tgmd.setPKColumnName(this.getAttr(attrs, "pk-column-name"));
                    tgmd.setPKColumnValue(this.getAttr(attrs, "pk-column-value"));
                    tgmd.setValueColumnName(this.getAttr(attrs, "value-column-name"));
                    tgmd.setInitialValue(this.getAttr(attrs, "initial-value"));
                    tgmd.setAllocationSize(this.getAttr(attrs, "allocation-size"));
                    break block144;
                }
                if (localName.equals("named-query")) {
                    md = this.getStack();
                    if (md instanceof FileMetaData) {
                        FileMetaData filemd4 = (FileMetaData)md;
                        QueryMetaData qmd = filemd4.newQueryMetadata(this.getAttr(attrs, "name"));
                        qmd.setLanguage(QueryLanguage.JPQL.toString());
                        this.pushStack((MetaData)qmd);
                    } else if (md instanceof ClassMetaData) {
                        ClassMetaData cmd2 = (ClassMetaData)md;
                        QueryMetaData qmd = new QueryMetaData(this.getAttr(attrs, "name"));
                        qmd.setLanguage(QueryLanguage.JPQL.toString());
                        cmd2.addQuery(qmd);
                        this.pushStack((MetaData)qmd);
                    }
                    break block144;
                }
                if (localName.equals("named-native-query")) {
                    md = this.getStack();
                    if (md instanceof FileMetaData) {
                        FileMetaData filemd5 = (FileMetaData)md;
                        QueryMetaData qmd = filemd5.newQueryMetadata(this.getAttr(attrs, "name"));
                        qmd.setLanguage(QueryLanguage.SQL.toString());
                        qmd.setResultClass(this.getAttr(attrs, "result-class"));
                        qmd.setResultMetaDataName(this.getAttr(attrs, "result-set-mapping"));
                        this.pushStack((MetaData)qmd);
                    } else if (md instanceof ClassMetaData) {
                        ClassMetaData cmd3 = (ClassMetaData)md;
                        QueryMetaData qmd = new QueryMetaData(this.getAttr(attrs, "name"));
                        qmd.setLanguage(QueryLanguage.SQL.toString());
                        qmd.setResultClass(this.getAttr(attrs, "result-class"));
                        qmd.setResultMetaDataName(this.getAttr(attrs, "result-set-mapping"));
                        cmd3.addQuery(qmd);
                        this.pushStack((MetaData)qmd);
                    }
                    break block144;
                }
                if (localName.equals("sql-result-set-mapping")) {
                    md = this.getStack();
                    if (md instanceof FileMetaData) {
                        FileMetaData filemd6 = (FileMetaData)md;
                        QueryResultMetaData qrmd2 = filemd6.newQueryResultMetadata(this.getAttr(attrs, "name"));
                        this.pushStack((MetaData)qrmd2);
                    } else if (md instanceof ClassMetaData) {
                        ClassMetaData cmd4 = (ClassMetaData)md;
                        QueryResultMetaData qrmd3 = new QueryResultMetaData(this.getAttr(attrs, "name"));
                        cmd4.addQueryResultMetaData(qrmd3);
                        this.pushStack((MetaData)qrmd3);
                    }
                    break block144;
                }
                if (localName.equals("entity-result")) {
                    qrmd = (QueryResultMetaData)this.getStack();
                    this.queryResultEntityName = this.getAttr(attrs, "entity-class");
                    qrmd.addPersistentTypeMapping(this.queryResultEntityName, null, this.getAttr(attrs, "discriminator-column"));
                    break block144;
                }
                if (localName.equals("field-result")) {
                    qrmd = (QueryResultMetaData)this.getStack();
                    qrmd.addMappingForPersistentTypeMapping(this.queryResultEntityName, this.getAttr(attrs, "name"), this.getAttr(attrs, "column"));
                    break block144;
                }
                if (localName.equals("column-result")) {
                    qrmd = (QueryResultMetaData)this.getStack();
                    qrmd.addScalarColumn(this.getAttr(attrs, "name"));
                    break block144;
                }
                if (localName.equals("mapped-superclass")) {
                    filemd = (FileMetaData)this.getStack();
                    String className = this.getAttr(attrs, "class");
                    String packageName = null;
                    if (className.indexOf(46) > 0) {
                        packageName = className.substring(0, className.lastIndexOf(46));
                    }
                    PackageMetaData pmd2 = null;
                    if (packageName != null) {
                        pmd2 = filemd.getPackage(packageName);
                    }
                    if (pmd2 == null) {
                        pmd2 = packageName != null ? filemd.newPackageMetadata(packageName) : (this.defaultPackageName != null ? filemd.getPackage(this.defaultPackageName) : filemd.newPackageMetadata(""));
                    }
                    ClassMetaData cmd5 = this.newClassObject(pmd2, attrs, false);
                    pmd2.addClass(cmd5);
                    InheritanceMetaData inhmd = new InheritanceMetaData();
                    inhmd.setStrategy(InheritanceStrategy.SUBCLASS_TABLE);
                    cmd5.setInheritanceMetaData(inhmd);
                    this.pushStack((MetaData)cmd5);
                    break block144;
                }
                if (localName.equals("query")) break block144;
                if (localName.equals("entity")) {
                    filemd = (FileMetaData)this.getStack();
                    String className = this.getAttr(attrs, "class");
                    String packageName = null;
                    if (className.indexOf(46) > 0) {
                        packageName = className.substring(0, className.lastIndexOf(46));
                    }
                    PackageMetaData pmd3 = null;
                    if (packageName != null) {
                        pmd3 = filemd.getPackage(packageName);
                    }
                    if (pmd3 == null) {
                        pmd3 = packageName != null ? filemd.newPackageMetadata(packageName) : (this.defaultPackageName != null ? filemd.getPackage(this.defaultPackageName) : filemd.newPackageMetadata(""));
                    }
                    ClassMetaData cmd6 = this.newClassObject(pmd3, attrs, false);
                    pmd3.addClass(cmd6);
                    this.pushStack((MetaData)cmd6);
                    break block144;
                }
                if (localName.equals("embeddable")) {
                    filemd = (FileMetaData)this.getStack();
                    String className = this.getAttr(attrs, "class");
                    String packageName = null;
                    if (className.indexOf(46) > 0) {
                        packageName = className.substring(0, className.lastIndexOf(46));
                    }
                    PackageMetaData pmd4 = null;
                    if (packageName != null) {
                        pmd4 = filemd.getPackage(packageName);
                    }
                    if (pmd4 == null) {
                        pmd4 = packageName != null ? filemd.newPackageMetadata(packageName) : (this.defaultPackageName != null ? filemd.getPackage(this.defaultPackageName) : filemd.newPackageMetadata(""));
                    }
                    ClassMetaData cmd7 = this.newClassObject(pmd4, attrs, true);
                    pmd4.addClass(cmd7);
                    this.pushStack((MetaData)cmd7);
                    break block144;
                }
                if (localName.equals("attributes") || localName.equals("embeddable-attributes")) break block144;
                if (localName.equals("id-class")) {
                    cmd = (ClassMetaData)this.getStack();
                    cmd.setObjectIdClass(this.getAttr(attrs, "class"));
                    break block144;
                }
                if (localName.equals("inheritance")) {
                    cmd = (ClassMetaData)this.getStack();
                    String strategy = this.getAttr(attrs, "strategy");
                    String strategyType = null;
                    if (strategy.equalsIgnoreCase("JOINED")) {
                        strategyType = InheritanceStrategy.NEW_TABLE.toString();
                    } else if (strategy.equalsIgnoreCase("TABLE_PER_CLASS")) {
                        strategyType = InheritanceStrategy.COMPLETE_TABLE.toString();
                    }
                    InheritanceMetaData inhmd = new InheritanceMetaData();
                    inhmd.setStrategy(this.getAttr(attrs, strategyType));
                    inhmd.setStrategyForTree(strategy.toUpperCase());
                    cmd.setInheritanceMetaData(inhmd);
                    break block144;
                }
                if (localName.equals("table")) {
                    cmd = (ClassMetaData)this.getStack();
                    cmd.setCatalog(this.getAttr(attrs, "catalog"));
                    cmd.setSchema(this.getAttr(attrs, "schema"));
                    cmd.setTable(this.getAttr(attrs, "name"));
                    break block144;
                }
                if (localName.equals("secondary-table")) {
                    cmd = (ClassMetaData)this.getStack();
                    JoinMetaData joinmd = new JoinMetaData();
                    joinmd.setTable(this.getAttr(attrs, "name"));
                    joinmd.setCatalog(this.getAttr(attrs, "catalog"));
                    joinmd.setSchema(this.getAttr(attrs, "schema"));
                    cmd.addJoin(joinmd);
                    this.pushStack((MetaData)joinmd);
                    break block144;
                }
                if (localName.equals("primary-key-join-column")) {
                    md = this.getStack();
                    if (md instanceof ClassMetaData) {
                        ClassMetaData cmd8 = (ClassMetaData)md;
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(this.getAttr(attrs, "name"));
                        colmd.setTarget(this.getAttr(attrs, "referenced-column-name"));
                        cmd8.getInheritanceMetaData().getJoinMetaData().addColumn(colmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(this.getAttr(attrs, "name"));
                        colmd.setTarget(this.getAttr(attrs, "referenced-column-name"));
                        joinmd.addColumn(colmd);
                    }
                    break block144;
                }
                if (localName.equals("id")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd2 = this.newPKFieldObject((AbstractClassMetaData)cmd, attrs);
                    this.pushStack((MetaData)mmd2);
                    break block144;
                }
                if (localName.equals("embedded-id")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd3 = this.newPKFieldObject((AbstractClassMetaData)cmd, attrs);
                    this.pushStack((MetaData)mmd3);
                    break block144;
                }
                if (localName.equals("basic")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd4 = this.newFieldObject((AbstractClassMetaData)cmd, attrs);
                    this.pushStack((MetaData)mmd4);
                    break block144;
                }
                if (localName.equals("lob")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    fmd.setStoreInLob();
                    break block144;
                }
                if (localName.equals("enumerated") || localName.equals("temporal")) break block144;
                if (localName.equals("transient")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd5 = this.newTransientFieldObject((MetaData)cmd, this.getAttr(attrs, "name"));
                    cmd.addMember(mmd5);
                    this.pushStack((MetaData)mmd5);
                    break block144;
                }
                if (localName.equals("one-to-many")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd6 = this.newFieldObject((AbstractClassMetaData)cmd, attrs);
                    String targetEntityName = this.getAttr(attrs, "target-entity");
                    if (!StringUtils.isWhitespace((String)targetEntityName)) {
                        mmd6.setTargetClassName(targetEntityName);
                    }
                    mmd6.setOrdered();
                    String jpaLevel = this.mgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.jpa.level");
                    if (mmd6.getMappedBy() == null && mmd6.getJoinMetaData() == null && jpaLevel.equalsIgnoreCase("JPA1")) {
                        mmd6.setJoinMetaData(new JoinMetaData());
                    }
                    this.pushStack((MetaData)mmd6);
                    break block144;
                }
                if (localName.equals("one-to-one")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd7 = this.newFieldObject((AbstractClassMetaData)cmd, attrs);
                    String targetEntityName = this.getAttr(attrs, "target-entity");
                    if (!StringUtils.isWhitespace((String)targetEntityName)) {
                        mmd7.setTargetClassName(targetEntityName);
                    }
                    this.pushStack((MetaData)mmd7);
                    break block144;
                }
                if (localName.equals("many-to-one")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd8 = this.newFieldObject((AbstractClassMetaData)cmd, attrs);
                    String targetEntityName = this.getAttr(attrs, "target-entity");
                    if (!StringUtils.isWhitespace((String)targetEntityName)) {
                        mmd8.setTargetClassName(targetEntityName);
                    }
                    this.pushStack((MetaData)mmd8);
                    break block144;
                }
                if (localName.equals("many-to-many")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd9 = this.newFieldObject((AbstractClassMetaData)cmd, attrs);
                    String targetEntityName = this.getAttr(attrs, "target-entity");
                    if (!StringUtils.isWhitespace((String)targetEntityName)) {
                        mmd9.setTargetClassName(targetEntityName);
                    }
                    mmd9.setOrdered();
                    if (mmd9.getMappedBy() == null && mmd9.getJoinMetaData() == null) {
                        mmd9.setJoinMetaData(new JoinMetaData());
                    }
                    this.pushStack((MetaData)mmd9);
                    break block144;
                }
                if (localName.equals("map-key")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    String mappedByFieldName = this.getAttr(attrs, "name");
                    if (StringUtils.isWhitespace((String)mappedByFieldName)) {
                        mappedByFieldName = "#PK";
                    }
                    KeyMetaData keymd = new KeyMetaData();
                    keymd.setMappedBy(mappedByFieldName);
                    fmd.setKeyMetaData(keymd);
                    break block144;
                }
                if (localName.equals("order-by")) break block144;
                if (localName.equals("order-column")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    String columnName = this.getAttr(attrs, "name");
                    OrderMetaData ordermd = new OrderMetaData();
                    ordermd.setColumnName(columnName);
                    String orderingOrigin = this.getAttr(attrs, "base");
                    if (orderingOrigin != null) {
                        try {
                            int origin = new Integer(orderingOrigin);
                            ordermd.setOrderOrigin(origin);
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(this.getAttr(attrs, "name"));
                    colmd.setAllowsNull(this.getAttr(attrs, "nullable"));
                    colmd.setInsertable(this.getAttr(attrs, "insertable"));
                    colmd.setUpdateable(this.getAttr(attrs, "updatable"));
                    ordermd.addColumn(colmd);
                    fmd.setOrderMetaData(ordermd);
                    break block144;
                }
                if (localName.equals("cascade") || localName.equals("cascade-type")) break block144;
                if (localName.equals("cascade-all")) {
                    mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadePersist(true);
                    mmd.setCascadeUpdate(true);
                    mmd.setCascadeDelete(true);
                    mmd.setCascadeRefresh(true);
                    break block144;
                }
                if (localName.equals("cascade-persist")) {
                    md = this.getStack();
                    if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData mmd10 = (AbstractMemberMetaData)md;
                        mmd10.setCascadePersist(true);
                    } else if (md instanceof FileMetaData) {
                        this.defaultCascadePersist = true;
                    }
                    break block144;
                }
                if (localName.equals("cascade-merge")) {
                    mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadeUpdate(true);
                    break block144;
                }
                if (localName.equals("cascade-remove")) {
                    mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadeDelete(true);
                    break block144;
                }
                if (localName.equals("cascade-refresh")) {
                    mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadeRefresh(true);
                    break block144;
                }
                if (localName.equals("version")) {
                    if (this.getStack() instanceof ClassMetaData) {
                        cmd = (ClassMetaData)this.getStack();
                        AbstractMemberMetaData mmd11 = this.newFieldObject((AbstractClassMetaData)cmd, attrs);
                        VersionMetaData vermd = cmd.newVersionMetadata();
                        vermd.setStrategy(VersionStrategy.VERSION_NUMBER).setFieldName(mmd11.getName());
                        this.pushStack((MetaData)mmd11);
                    }
                    break block144;
                }
                if (localName.equals("discriminator-value")) break block144;
                if (localName.equals("discriminator-column")) {
                    DiscriminatorMetaData dismd;
                    cmd = (ClassMetaData)this.getStack();
                    InheritanceMetaData inhmd = cmd.getInheritanceMetaData();
                    if (inhmd == null) {
                        inhmd = new InheritanceMetaData();
                        cmd.setInheritanceMetaData(inhmd);
                    }
                    if ((dismd = inhmd.getDiscriminatorMetaData()) == null) {
                        dismd = inhmd.newDiscriminatorMetadata();
                        dismd.setStrategy(DiscriminatorStrategy.CLASS_NAME);
                        dismd.setIndexed("true");
                    }
                    String jdbcType = null;
                    String discType = this.getAttr(attrs, "discriminator-type");
                    if (discType != null) {
                        if (discType.equalsIgnoreCase("STRING")) {
                            jdbcType = "VARCHAR";
                        } else if (discType.equalsIgnoreCase("CHAR")) {
                            jdbcType = "CHAR";
                        } else if (discType.equalsIgnoreCase("INTEGER")) {
                            jdbcType = "INTEGER";
                        }
                    }
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(this.getAttr(attrs, "name"));
                    colmd.setJdbcType(jdbcType);
                    dismd.setColumnMetaData(colmd);
                    break block144;
                }
                if (localName.equals("generated-value")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    IdentityStrategy idStrategy = IdentityStrategy.getIdentityStrategy((String)this.getAttr(attrs, "strategy"));
                    fmd.setValueStrategy(idStrategy);
                    fmd.setValueGeneratorName(this.getAttr(attrs, "generator"));
                    break block144;
                }
                if (localName.equals("join-table")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    JoinMetaData joinmd = new JoinMetaData();
                    String tableName = this.getAttr(attrs, "name");
                    String schemaName = this.getAttr(attrs, "schema");
                    String catalogName = this.getAttr(attrs, "catalog");
                    fmd.setJoinMetaData(joinmd);
                    if (!StringUtils.isWhitespace((String)tableName)) {
                        fmd.setTable(tableName);
                    }
                    if (!StringUtils.isWhitespace((String)schemaName)) {
                        fmd.setSchema(schemaName);
                    }
                    if (!StringUtils.isWhitespace((String)catalogName)) {
                        fmd.setSchema(catalogName);
                    }
                    this.pushStack((MetaData)joinmd);
                    break block144;
                }
                if (localName.equals("column")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(this.getAttr(attrs, "name"));
                    colmd.setLength(this.getAttr(attrs, "length"));
                    colmd.setScale(this.getAttr(attrs, "scale"));
                    colmd.setAllowsNull(this.getAttr(attrs, "nullable"));
                    colmd.setInsertable(this.getAttr(attrs, "insertable"));
                    colmd.setUpdateable(this.getAttr(attrs, "updatable"));
                    colmd.setUnique(this.getAttr(attrs, "unique"));
                    fmd.addColumn(colmd);
                    String table = this.getAttr(attrs, "table");
                    if (!StringUtils.isWhitespace((String)table)) {
                        fmd.setTable(table);
                    }
                    break block144;
                }
                if (localName.equals("join-column")) {
                    md = this.getStack();
                    if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(this.getAttr(attrs, "name"));
                        colmd.setTarget(this.getAttr(attrs, "referenced-column-name"));
                        colmd.setAllowsNull(this.getAttr(attrs, "nullable"));
                        colmd.setInsertable(this.getAttr(attrs, "insertable"));
                        colmd.setUpdateable(this.getAttr(attrs, "updatable"));
                        colmd.setUnique(this.getAttr(attrs, "unique"));
                        joinmd.addColumn(colmd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd2 = (AbstractMemberMetaData)md;
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(this.getAttr(attrs, "name"));
                        colmd.setTarget(this.getAttr(attrs, "referenced-column-name"));
                        colmd.setAllowsNull(this.getAttr(attrs, "nullable"));
                        colmd.setInsertable(this.getAttr(attrs, "insertable"));
                        colmd.setUpdateable(this.getAttr(attrs, "updatable"));
                        colmd.setUnique(this.getAttr(attrs, "unique"));
                        fmd2.addColumn(colmd);
                    }
                    break block144;
                }
                if (localName.equals("inverse-join-column")) {
                    md = this.getStack();
                    if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        ElementMetaData elemmd = null;
                        AbstractMemberMetaData fmd3 = (AbstractMemberMetaData)joinmd.getParent();
                        if (fmd3.getElementMetaData() != null) {
                            elemmd = fmd3.getElementMetaData();
                        } else {
                            elemmd = new ElementMetaData();
                            fmd3.setElementMetaData(elemmd);
                        }
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setName(this.getAttr(attrs, "name"));
                        colmd.setTarget(this.getAttr(attrs, "referenced-column-name"));
                        colmd.setAllowsNull(this.getAttr(attrs, "nullable"));
                        colmd.setInsertable(this.getAttr(attrs, "insertable"));
                        colmd.setUpdateable(this.getAttr(attrs, "updatable"));
                        colmd.setUnique(this.getAttr(attrs, "unique"));
                        elemmd.addColumn(colmd);
                    }
                    break block144;
                }
                if (localName.equals("unique-constraint")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd9 = (AbstractClassMetaData)md;
                        UniqueMetaData unimd = new UniqueMetaData();
                        unimd.setTable(cmd9.getTable());
                        cmd9.addUniqueConstraint(unimd);
                        this.pushStack((MetaData)unimd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        UniqueMetaData unimd = new UniqueMetaData();
                        joinmd.setUniqueMetaData(unimd);
                        this.pushStack((MetaData)unimd);
                    }
                    break block144;
                }
                if (localName.equals("entity-listeners")) break block144;
                if (localName.equals("entity-listener")) {
                    md = this.getStack();
                    EventListenerMetaData elmd = new EventListenerMetaData(this.getAttr(attrs, "class"));
                    if (md instanceof AbstractClassMetaData) {
                        ((AbstractClassMetaData)md).addListener(elmd);
                    } else if (md instanceof FileMetaData) {
                        ((FileMetaData)md).addListener(elmd);
                    }
                    this.pushStack((MetaData)elmd);
                    break block144;
                }
                if (localName.equals("pre-persist")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd10 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd10.getListenerForClass(cmd10.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd10.getFullClassName());
                            cmd10.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PrePersist", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PrePersist", this.getAttr(attrs, "method-name"));
                    }
                    break block144;
                }
                if (localName.equals("post-persist")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd11 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd11.getListenerForClass(cmd11.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd11.getFullClassName());
                            cmd11.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PostPersist", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PostPersist", this.getAttr(attrs, "method-name"));
                    }
                    break block144;
                }
                if (localName.equals("pre-remove")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd12 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd12.getListenerForClass(cmd12.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd12.getFullClassName());
                            cmd12.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PreRemove", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PreRemove", this.getAttr(attrs, "method-name"));
                    }
                    break block144;
                }
                if (localName.equals("post-remove")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd13 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd13.getListenerForClass(cmd13.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd13.getFullClassName());
                            cmd13.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PostRemove", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PostRemove", this.getAttr(attrs, "method-name"));
                    }
                    break block144;
                }
                if (localName.equals("pre-update")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd14 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd14.getListenerForClass(cmd14.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd14.getFullClassName());
                            cmd14.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PreUpdate", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PreUpdate", this.getAttr(attrs, "method-name"));
                    }
                    break block144;
                }
                if (localName.equals("post-update")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd15 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd15.getListenerForClass(cmd15.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd15.getFullClassName());
                            cmd15.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PostUpdate", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PostUpdate", this.getAttr(attrs, "method-name"));
                    }
                    break block144;
                }
                if (localName.equals("post-load")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd16 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd16.getListenerForClass(cmd16.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd16.getFullClassName());
                            cmd16.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PostLoad", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PostLoad", this.getAttr(attrs, "method-name"));
                    }
                    break block144;
                }
                if (localName.equals("attribute-override")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    AbstractMemberMetaData fmd4 = this.newOverriddenFieldObject((MetaData)cmd, attrs);
                    cmd.addMember(fmd4);
                    this.pushStack((MetaData)fmd4);
                    break block144;
                }
                if (localName.equals("association-override")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    AbstractMemberMetaData fmd5 = this.newOverriddenFieldObject((MetaData)cmd, attrs);
                    cmd.addMember(fmd5);
                    this.pushStack((MetaData)fmd5);
                    break block144;
                }
                if (localName.equals("exclude-default-listeners")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.excludeDefaultListeners();
                    break block144;
                }
                if (localName.equals("exclude-superclass-listeners")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.excludeSuperClassListeners();
                    break block144;
                }
                String message = LOCALISER.msg("044037", (Object)qName);
                NucleusLogger.METADATA.error((Object)message);
                throw new RuntimeException(message);
            }
            catch (RuntimeException ex) {
                NucleusLogger.METADATA.error((Object)LOCALISER.msg("044042", (Object)qName, (Object)this.getStack(), (Object)uri), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentString;
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044035", (Object)("<" + qName + ">"), (Object)("" + this.stack.size())));
        }
        if (localName.length() < 1) {
            localName = qName;
        }
        if ((currentString = this.getString().trim()).length() > 0) {
            MetaData md = this.getStack();
            if (localName.equals("schema")) {
                if (md instanceof FileMetaData) {
                    ((FileMetaData)md).setSchema(currentString);
                }
            } else if (localName.equals("catalog")) {
                if (md instanceof FileMetaData) {
                    ((FileMetaData)md).setCatalog(currentString);
                }
            } else if (localName.equals("access")) {
                if (md instanceof FileMetaData && currentString.equalsIgnoreCase("PROPERTY")) {
                    this.propertyAccess = true;
                }
            } else if (localName.equals("package")) {
                if (md instanceof FileMetaData) {
                    FileMetaData filemd = (FileMetaData)md;
                    filemd.newPackageMetadata(currentString);
                    this.defaultPackageName = currentString;
                }
            } else if (localName.equals("discriminator-value")) {
                if (md instanceof ClassMetaData) {
                    ClassMetaData cmd = (ClassMetaData)md;
                    InheritanceMetaData inhmd = cmd.getInheritanceMetaData();
                    if (inhmd == null) {
                        inhmd = new InheritanceMetaData();
                        cmd.setInheritanceMetaData(inhmd);
                    }
                    String discrimValue = currentString;
                    DiscriminatorMetaData dismd = inhmd.newDiscriminatorMetadata();
                    dismd.setValue(discrimValue);
                    dismd.setStrategy(DiscriminatorStrategy.VALUE_MAP);
                }
            } else if (localName.equals("column-name")) {
                if (md instanceof UniqueMetaData) {
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(currentString);
                    ((UniqueMetaData)md).addColumn(colmd);
                }
            } else if (localName.equals("order-by")) {
                if (md instanceof AbstractMemberMetaData) {
                    AbstractMemberMetaData fmd = (AbstractMemberMetaData)md;
                    OrderMetaData ordmd = new OrderMetaData();
                    ordmd.setOrdering(currentString);
                    fmd.setOrderMetaData(ordmd);
                }
            } else if (localName.equals("query")) {
                if (md instanceof QueryMetaData) {
                    ((QueryMetaData)md).setQuery(currentString);
                }
            } else if (localName.equals("enumerated")) {
                if (md instanceof AbstractMemberMetaData) {
                    AbstractMemberMetaData mmd = (AbstractMemberMetaData)md;
                    String enumerationType = currentString;
                    String jdbcType = "INTEGER";
                    if (enumerationType.equalsIgnoreCase("STRING")) {
                        jdbcType = "VARCHAR";
                    }
                    if (mmd.getColumnMetaData() == null) {
                        ColumnMetaData colmd = new ColumnMetaData();
                        colmd.setJdbcType(jdbcType);
                        mmd.addColumn(colmd);
                    } else {
                        mmd.getColumnMetaData()[0].setJdbcType(jdbcType);
                    }
                }
            } else if (localName.equals("temporal") && md instanceof AbstractMemberMetaData) {
                AbstractMemberMetaData mmd = (AbstractMemberMetaData)md;
                String enumerationType = currentString;
                String jdbcType = null;
                if (enumerationType.equalsIgnoreCase("DATE")) {
                    jdbcType = "DATE";
                } else if (enumerationType.equalsIgnoreCase("TIME")) {
                    jdbcType = "TIME";
                } else if (enumerationType.equalsIgnoreCase("TIMESTAMP")) {
                    jdbcType = "TIMESTAMP";
                }
                if (mmd.getColumnMetaData() == null) {
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setJdbcType(jdbcType);
                    mmd.addColumn(colmd);
                } else {
                    mmd.getColumnMetaData()[0].setJdbcType(jdbcType);
                }
            }
        }
        if (localName.equals("entity") || localName.equals("mapped-superclass") || localName.equals("entity-listener") || localName.equals("attribute-override") || localName.equals("association-override") || localName.equals("id") || localName.equals("embedded-id") || localName.equals("basic") || localName.equals("transient") || localName.equals("one-to-one") || localName.equals("one-to-many") || localName.equals("many-to-one") || localName.equals("many-to-many") || localName.equals("version") || localName.equals("secondary-table") || localName.equals("join-table") || localName.equals("unique-constraint") || localName.equals("named-query") || localName.equals("named-native-query") || localName.equals("sql-result-set-mapping")) {
            this.popStack();
        }
    }
}

