/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.key;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.rdbms.table.Column;

abstract class Key {
    protected String name;
    protected DatastoreContainerObject table;
    protected List<DatastoreField> columns = new ArrayList<DatastoreField>();

    protected Key(DatastoreContainerObject table) {
        this.table = table;
    }

    public String getName() {
        return this.name;
    }

    public DatastoreContainerObject getDatastoreContainerObject() {
        return this.table;
    }

    public List<DatastoreField> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public String getColumnList() {
        return Key.getColumnList(this.columns);
    }

    public void addDatastoreField(DatastoreField col) {
        this.assertSameDatastoreObject(col);
        this.columns.add(col);
    }

    public boolean startsWith(Key key) {
        int kSize = key.columns.size();
        return kSize <= this.columns.size() && key.columns.equals(this.columns.subList(0, kSize));
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void assertSameDatastoreObject(DatastoreField col) {
        if (!this.table.equals(col.getDatastoreContainerObject())) {
            throw new NucleusException("Cannot add " + col + " as key column for " + this.table).setFatal();
        }
    }

    public int hashCode() {
        return this.columns.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Key)) {
            return false;
        }
        Key key = (Key)obj;
        return this.columns.containsAll(key.columns) && this.columns.size() == key.columns.size();
    }

    protected static void setMinSize(List list, int size) {
        while (list.size() < size) {
            list.add(null);
        }
    }

    public static String getColumnList(Collection cols) {
        StringBuffer s = new StringBuffer("(");
        Iterator i = cols.iterator();
        while (i.hasNext()) {
            Column col = (Column)i.next();
            if (col == null) {
                s.append('?');
            } else {
                s.append(col.getIdentifier());
            }
            if (!i.hasNext()) continue;
            s.append(',');
        }
        s.append(')');
        return s.toString();
    }
}

