/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.util.HashSet;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.StatementGenerator;

public abstract class AbstractStatementGenerator
implements StatementGenerator {
    protected final RDBMSStoreManager storeMgr;
    protected final ClassLoaderResolver clr;
    protected SQLStatement parentStmt = null;
    protected Class candidateType;
    protected final boolean includeSubclasses;
    protected DatastoreClass candidateTable;
    protected DatastoreIdentifier candidateTableAlias;
    protected String candidateTableGroupName = null;
    DatastoreContainerObject joinTable = null;
    DatastoreIdentifier joinTableAlias = null;
    JavaTypeMapping joinElementMapping = null;
    Set<String> options = new HashSet<String>();

    public AbstractStatementGenerator(RDBMSStoreManager storeMgr, ClassLoaderResolver clr, Class candidateType, boolean subclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName) {
        this.storeMgr = storeMgr;
        this.clr = clr;
        this.candidateType = candidateType;
        this.includeSubclasses = subclasses;
        this.candidateTableGroupName = candidateTableGroupName;
        String candidateClassName = candidateType.getName();
        AbstractClassMetaData acmd = storeMgr.getMetaDataManager().getMetaDataForClass(candidateType, clr);
        if (!storeMgr.getMappedTypeManager().isSupportedMappedType(candidateClassName)) {
            if (acmd == null) {
                throw new NucleusUserException("Attempt to create SQL statement for type without metadata! : " + candidateType.getName());
            }
            this.candidateTable = storeMgr.getDatastoreClass(acmd.getFullClassName(), clr);
            if (this.candidateTable == null) {
                AbstractClassMetaData[] subcmds = storeMgr.getClassesManagingTableForClass(acmd, clr);
                if (subcmds == null || subcmds.length > 1) {
                    throw new NucleusException("Attempt to generate SQL statement for instances of " + candidateType.getName() + " but has no table of its own and not single subclass with table so unsupported");
                }
                this.candidateTable = storeMgr.getDatastoreClass(subcmds[0].getFullClassName(), clr);
            }
        }
        this.candidateTableAlias = candidateTableAlias;
    }

    public AbstractStatementGenerator(RDBMSStoreManager storeMgr, ClassLoaderResolver clr, Class candidateType, boolean subclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName, DatastoreContainerObject joinTable, DatastoreIdentifier joinTableAlias, JavaTypeMapping joinElementMapping) {
        this(storeMgr, clr, candidateType, subclasses, candidateTableAlias, candidateTableGroupName);
        this.joinTable = joinTable;
        this.joinTableAlias = joinTableAlias;
        this.joinElementMapping = joinElementMapping;
    }

    @Override
    public StatementGenerator setOption(String name) {
        this.options.add(name);
        return this;
    }

    @Override
    public StatementGenerator unsetOption(String name) {
        this.options.remove(name);
        return this;
    }

    @Override
    public boolean hasOption(String name) {
        return this.options.contains(name);
    }
}

