/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.ConnectionFactoryNotFoundException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.UnsupportedConnectionFactoryException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.rdbms.ConnectionProvider;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.datasource.DataNucleusDataSourceFactory;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.JavaUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    DataSource[] dataSources;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        if (resourceType.equals("tx")) {
            this.initialiseDataSources();
        }
    }

    protected synchronized void initialiseDataSources() {
        if (this.resourceType.equals("tx")) {
            String configuredResourceTypeProperty = this.storeMgr.getStringProperty("datanucleus.connection.resourceType");
            if (configuredResourceTypeProperty != null) {
                if (this.options == null) {
                    this.options = new HashMap();
                }
                this.options.put("resource-type", configuredResourceTypeProperty);
            }
            String requiredPoolingType = this.storeMgr.getStringProperty("datanucleus.connectionPoolingType");
            Object connDS = this.storeMgr.getConnectionFactory();
            String connJNDI = this.storeMgr.getConnectionFactoryName();
            String connURL = this.storeMgr.getConnectionURL();
            this.dataSources = ConnectionFactoryImpl.generateDataSources(this.storeMgr, connDS, connJNDI, this.resourceType, requiredPoolingType, connURL);
            if (this.dataSources == null) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("047009", (Object)"transactional")).setFatal();
            }
        } else {
            String requiredPoolingType;
            String configuredResourceTypeProperty = this.storeMgr.getStringProperty("datanucleus.connection2.resourceType");
            if (configuredResourceTypeProperty != null) {
                if (this.options == null) {
                    this.options = new HashMap();
                }
                this.options.put("resource-type", configuredResourceTypeProperty);
            }
            if ((requiredPoolingType = this.storeMgr.getStringProperty("datanucleus.connectionPoolingType.nontx")) == null) {
                requiredPoolingType = this.storeMgr.getStringProperty("datanucleus.connectionPoolingType");
            }
            Object connDS = this.storeMgr.getConnectionFactory2();
            String connJNDI = this.storeMgr.getConnectionFactory2Name();
            String connURL = this.storeMgr.getConnectionURL();
            this.dataSources = ConnectionFactoryImpl.generateDataSources(this.storeMgr, connDS, connJNDI, this.resourceType, requiredPoolingType, connURL);
            if (this.dataSources == null) {
                connDS = this.storeMgr.getConnectionFactory();
                connJNDI = this.storeMgr.getConnectionFactoryName();
                this.dataSources = ConnectionFactoryImpl.generateDataSources(this.storeMgr, connDS, connJNDI, this.resourceType, requiredPoolingType, connURL);
            }
            if (this.dataSources == null) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("047009", (Object)"non-transactional")).setFatal();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DataSource[] generateDataSources(StoreManager storeMgr, Object connDS, String connJNDI, String resourceType, String requiredPoolingType, String connURL) {
        DataSource[] dataSources = null;
        if (connDS != null) {
            if (!(connDS instanceof DataSource) && !(connDS instanceof XADataSource)) {
                throw new UnsupportedConnectionFactoryException(connDS);
            }
            dataSources = new DataSource[]{(DataSource)connDS};
            return dataSources;
        }
        if (connJNDI != null) {
            String[] connectionFactoryNames = StringUtils.split((String)connJNDI, (String)",");
            dataSources = new DataSource[connectionFactoryNames.length];
            for (int i = 0; i < connectionFactoryNames.length; ++i) {
                Object obj;
                try {
                    obj = new InitialContext().lookup(connectionFactoryNames[i]);
                }
                catch (NamingException e) {
                    throw new ConnectionFactoryNotFoundException(connectionFactoryNames[i], (Exception)e);
                }
                if (!(obj instanceof DataSource) && !(obj instanceof XADataSource)) {
                    throw new UnsupportedConnectionFactoryException(obj);
                }
                dataSources[i] = (DataSource)obj;
            }
            return dataSources;
        }
        if (connURL == null) return dataSources;
        dataSources = new DataSource[1];
        String poolingType = ConnectionFactoryImpl.calculatePoolingType(storeMgr, requiredPoolingType);
        try {
            DataNucleusDataSourceFactory dataSourceFactory = (DataNucleusDataSourceFactory)storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.datasource", "name", poolingType, "class-name", null, null);
            if (dataSourceFactory == null) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("047003", (Object)poolingType)).setFatal();
            }
            dataSources[0] = dataSourceFactory.makePooledDataSource(storeMgr);
            if (!NucleusLogger.CONNECTION.isDebugEnabled()) return dataSources;
            NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("047008", (Object)resourceType, (Object)poolingType));
            return dataSources;
        }
        catch (ClassNotFoundException cnfe) {
            throw new NucleusUserException(LOCALISER_RDBMS.msg("047003", (Object)poolingType), (Throwable)cnfe).setFatal();
        }
        catch (Exception e) {
            if (!(e instanceof InvocationTargetException)) throw new NucleusException(LOCALISER_RDBMS.msg("047004", (Object)poolingType, (Object)e.getMessage()), (Throwable)e).setFatal();
            InvocationTargetException ite = (InvocationTargetException)e;
            throw new NucleusException(LOCALISER_RDBMS.msg("047004", (Object)poolingType, (Object)ite.getTargetException().getMessage()), ite.getTargetException()).setFatal();
        }
    }

    public ManagedConnection createManagedConnection(ExecutionContext ec, Map txnOptions) {
        boolean releaseAfterUse;
        if (this.dataSources == null) {
            this.initialiseDataSources();
        }
        ManagedConnectionImpl mconn = new ManagedConnectionImpl(txnOptions);
        if (this.resourceType.equalsIgnoreCase("nontx") && !(releaseAfterUse = this.storeMgr.getBooleanProperty("datanucleus.connection.nontx.releaseAfterUse"))) {
            mconn.setCloseOnRelease(false);
        }
        return mconn;
    }

    protected static String calculatePoolingType(StoreManager storeMgr, String requiredPoolingType) {
        String poolingType = requiredPoolingType;
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        if (poolingType != null) {
            if (poolingType.equalsIgnoreCase("DBCP") && !ConnectionFactoryImpl.dbcpPresent(clr)) {
                NucleusLogger.CONNECTION.warn((Object)"DBCP specified but not present in CLASSPATH (or one of dependencies)");
                poolingType = null;
            } else if (poolingType.equalsIgnoreCase("C3P0") && !ConnectionFactoryImpl.c3p0Present(clr)) {
                NucleusLogger.CONNECTION.warn((Object)"C3P0 specified but not present in CLASSPATH (or one of dependencies)");
                poolingType = null;
            } else if (poolingType.equalsIgnoreCase("Proxool") && !ConnectionFactoryImpl.proxoolPresent(clr)) {
                NucleusLogger.CONNECTION.warn((Object)"Proxool specified but not present in CLASSPATH (or one of dependencies)");
                poolingType = null;
            } else if (poolingType.equalsIgnoreCase("BoneCP") && !ConnectionFactoryImpl.bonecpPresent(clr)) {
                NucleusLogger.CONNECTION.warn((Object)"BoneCP specified but not present in CLASSPATH (or one of dependencies)");
                poolingType = null;
            }
        }
        if (poolingType == null && ConnectionFactoryImpl.dbcpPresent(clr)) {
            poolingType = "DBCP";
        }
        if (poolingType == null && ConnectionFactoryImpl.c3p0Present(clr)) {
            poolingType = "C3P0";
        }
        if (poolingType == null && ConnectionFactoryImpl.proxoolPresent(clr)) {
            poolingType = "Proxool";
        }
        if (poolingType == null && ConnectionFactoryImpl.bonecpPresent(clr)) {
            poolingType = "BoneCP";
        }
        if (poolingType == null) {
            poolingType = JavaUtils.isJRE1_6OrAbove() ? "dbcp-builtin" : "None";
        }
        return poolingType;
    }

    protected static boolean dbcpPresent(ClassLoaderResolver clr) {
        try {
            clr.classForName("org.apache.commons.pool.ObjectPool");
            clr.classForName("org.apache.commons.dbcp.ConnectionFactory");
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    protected static boolean c3p0Present(ClassLoaderResolver clr) {
        try {
            clr.classForName("com.mchange.v2.c3p0.ComboPooledDataSource");
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    protected static boolean proxoolPresent(ClassLoaderResolver clr) {
        try {
            clr.classForName("org.logicalcobwebs.proxool.ProxoolDriver");
            clr.classForName("org.apache.commons.logging.Log");
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    protected static boolean bonecpPresent(ClassLoaderResolver clr) {
        try {
            clr.classForName("com.jolbox.bonecp.BoneCPDataSource");
            clr.classForName("org.slf4j.Logger");
            clr.classForName("com.google.common.collect.Multiset");
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    static class EmulatedXAResource
    implements XAResource {
        Connection conn;

        EmulatedXAResource(Connection conn) {
            this.conn = conn;
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is committing for transaction " + xid.toString() + " with onePhase=" + onePhase));
            try {
                this.conn.commit();
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " committed connection for transaction " + xid.toString() + " with onePhase=" + onePhase));
            }
            catch (SQLException e) {
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " failed to commit connection for transaction " + xid.toString() + " with onePhase=" + onePhase));
                XAException xe = new XAException(StringUtils.getStringFromStackTrace((Throwable)e));
                xe.initCause(e);
                throw xe;
            }
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is ending for transaction " + xid.toString() + " with flags " + flags));
        }

        @Override
        public void forget(Xid arg0) throws XAException {
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        @Override
        public boolean isSameRM(XAResource xares) throws XAException {
            return this == xares;
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is preparing for transaction " + xid.toString()));
            return 0;
        }

        @Override
        public Xid[] recover(int flags) throws XAException {
            throw new XAException("Unsupported operation");
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is rolling back for transaction " + xid.toString()));
            try {
                this.conn.rollback();
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " rolled back connection for transaction " + xid.toString()));
            }
            catch (SQLException e) {
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " failed to rollback connection for transaction " + xid.toString()));
                XAException xe = new XAException(StringUtils.getStringFromStackTrace((Throwable)e));
                xe.initCause(e);
                throw xe;
            }
        }

        @Override
        public boolean setTransactionTimeout(int arg0) throws XAException {
            return false;
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is starting for transaction " + xid.toString() + " with flags " + flags));
        }
    }

    class ManagedConnectionImpl
    extends AbstractManagedConnection {
        int isolation;
        boolean needsCommitting = false;
        ConnectionProvider connProvider = null;

        ManagedConnectionImpl(Map txnOptions) {
            this.isolation = txnOptions != null && txnOptions.get("transaction.isolation") != null ? ((Number)txnOptions.get("transaction.isolation")).intValue() : TransactionUtils.getTransactionIsolationLevelForName((String)ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.transactionIsolation"));
            try {
                this.connProvider = (ConnectionProvider)ConnectionFactoryImpl.this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.connectionprovider", "name", ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.rdbms.connectionProviderName"), "class-name", null, null);
                if (this.connProvider == null) {
                    throw new NucleusException(LOCALISER_RDBMS.msg("050000", (Object)ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.rdbms.connectionProviderName"))).setFatal();
                }
                this.connProvider.setFailOnError(ConnectionFactoryImpl.this.storeMgr.getBooleanProperty("datanucleus.rdbms.connectionProviderFailOnError"));
            }
            catch (Exception e) {
                throw new NucleusException(LOCALISER_RDBMS.msg("050001", (Object)ConnectionFactoryImpl.this.storeMgr.getStringProperty("datanucleus.rdbms.connectionProviderName"), (Object)e.getMessage()), (Throwable)e).setFatal();
            }
        }

        public void release() {
            if (this.commitOnRelease) {
                try {
                    Connection conn = this.getSqlConnection();
                    if (conn != null && !conn.isClosed() && !conn.getAutoCommit()) {
                        ((RDBMSStoreManager)ConnectionFactoryImpl.this.storeMgr).getSQLController().processConnectionStatement((ManagedConnection)this);
                        this.needsCommitting = false;
                        conn.commit();
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052005", (Object)StringUtils.toJVMIDString((Object)conn)));
                        }
                    }
                }
                catch (SQLException sqle) {
                    throw new NucleusDataStoreException(sqle.getMessage(), (Throwable)sqle);
                }
            }
            super.release();
        }

        public XAResource getXAResource() {
            if (this.getConnection() instanceof Connection) {
                return new EmulatedXAResource((Connection)this.getConnection());
            }
            try {
                return ((XAConnection)this.getConnection()).getXAResource();
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }

        public Object getConnection() {
            if (this.conn == null) {
                Connection cnx;
                block28: {
                    cnx = null;
                    try {
                        RDBMSStoreManager rdbmsMgr = (RDBMSStoreManager)ConnectionFactoryImpl.this.storeMgr;
                        boolean readOnly = ConnectionFactoryImpl.this.storeMgr.getBooleanProperty("datanucleus.readOnlyDatastore");
                        if (rdbmsMgr.getDatastoreAdapter() != null) {
                            DatastoreAdapter rdba = rdbmsMgr.getDatastoreAdapter();
                            int reqdIsolationLevel = this.isolation;
                            if (rdba.getRequiredTransactionIsolationLevel() >= 0) {
                                reqdIsolationLevel = rdba.getRequiredTransactionIsolationLevel();
                            }
                            cnx = this.connProvider.getConnection(ConnectionFactoryImpl.this.dataSources);
                            boolean succeeded = false;
                            try {
                                if (cnx.isReadOnly() != readOnly) {
                                    NucleusLogger.CONNECTION.debug((Object)("Setting readonly=" + readOnly + " to connection: " + cnx.toString()));
                                    cnx.setReadOnly(readOnly);
                                }
                                if (reqdIsolationLevel == 0) {
                                    if (!cnx.getAutoCommit()) {
                                        cnx.setAutoCommit(true);
                                    }
                                } else {
                                    if (cnx.getAutoCommit()) {
                                        cnx.setAutoCommit(false);
                                    }
                                    if (rdba.supportsTransactionIsolation(reqdIsolationLevel)) {
                                        int currentIsolationLevel = cnx.getTransactionIsolation();
                                        if (currentIsolationLevel != reqdIsolationLevel) {
                                            cnx.setTransactionIsolation(reqdIsolationLevel);
                                        }
                                    } else {
                                        NucleusLogger.CONNECTION.warn((Object)LOCALISER_RDBMS.msg("051008", (long)reqdIsolationLevel));
                                    }
                                }
                                if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                                    NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052002", (Object)StringUtils.toJVMIDString((Object)cnx), (Object)TransactionUtils.getNameForTransactionIsolationLevel((int)reqdIsolationLevel), (Object)cnx.getAutoCommit()));
                                }
                                if (reqdIsolationLevel != this.isolation && this.isolation == 0 && !cnx.getAutoCommit()) {
                                    NucleusLogger.CONNECTION.debug((Object)("Setting autocommit=true for connection: " + StringUtils.toJVMIDString((Object)cnx)));
                                    cnx.setAutoCommit(true);
                                }
                                succeeded = true;
                                break block28;
                            }
                            catch (SQLException e) {
                                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                            }
                            finally {
                                if (!succeeded) {
                                    try {
                                        cnx.close();
                                    }
                                    catch (SQLException e) {}
                                    if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                                        NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052003", (Object)StringUtils.toJVMIDString((Object)cnx)));
                                    }
                                }
                            }
                        }
                        cnx = ConnectionFactoryImpl.this.dataSources[0].getConnection();
                        if (cnx == null) {
                            String msg = LOCALISER_RDBMS.msg("052000", (Object)ConnectionFactoryImpl.this.dataSources[0]);
                            NucleusLogger.CONNECTION.error((Object)msg);
                            throw new NucleusDataStoreException(msg);
                        }
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052001", (Object)StringUtils.toJVMIDString((Object)cnx)));
                        }
                    }
                    catch (SQLException e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                }
                this.conn = cnx;
            }
            this.needsCommitting = true;
            return this.conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            Connection conn = this.getSqlConnection();
            if (conn != null) {
                try {
                    if (this.commitOnRelease && this.needsCommitting && !conn.isClosed() && !conn.getAutoCommit()) {
                        SQLController sqlController = ((RDBMSStoreManager)ConnectionFactoryImpl.this.storeMgr).getSQLController();
                        if (sqlController != null) {
                            sqlController.processConnectionStatement((ManagedConnection)this);
                        }
                        conn.commit();
                        this.needsCommitting = false;
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052005", (Object)StringUtils.toJVMIDString((Object)conn)));
                        }
                    }
                    if (!conn.isClosed()) {
                        conn.close();
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052003", (Object)StringUtils.toJVMIDString((Object)conn)));
                        }
                    } else if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                        NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052004", (Object)StringUtils.toJVMIDString((Object)conn)));
                    }
                }
                catch (SQLException sqle) {
                    throw new NucleusDataStoreException(sqle.getMessage(), (Throwable)sqle);
                }
            }
            try {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
                }
            }
            finally {
                this.listeners.clear();
            }
            this.conn = null;
        }

        private Connection getSqlConnection() {
            if (this.conn != null && this.conn instanceof Connection) {
                return (Connection)this.conn;
            }
            if (this.conn != null && this.conn instanceof XAConnection) {
                try {
                    return ((XAConnection)this.conn).getConnection();
                }
                catch (SQLException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            return null;
        }
    }
}

